/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.util;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.performance.monitor.ejb.session.MonitorPerfController;
import com.clustercontrol.performance.monitor.ejb.session.MonitorPerfControllerHome;
import com.clustercontrol.util.LoginManager;

/**
 * EJBとのコネクションを管理するクラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class EjbConnectionManager {
    public static final String KEY_EJB_URL = "ejbUrl";
    public static final String VALUE_EJB_URL = "jnp://localhost:1099";
    private static EjbConnectionManager m_instance = null;
    private NamingContext m_ctx = null;

    /**
     * このオブジェクトを取得します。
     * 
     * @return ConnectionManager コネクションマネージャ
     */
    public static EjbConnectionManager getConnectionManager() {
        if (m_instance == null) {
            m_instance = new EjbConnectionManager();
        }
        return m_instance;
    }

    private EjbConnectionManager() {

    }

    /**
     * ProcessControllerを取得します。
     * 
     * @return MonitorController
     */
    public synchronized MonitorPerfController getMonitorPerfController() {  	
    	try {
            m_ctx = LoginManager.getContextManager().getNamingContext();
        } catch (NamingException e) {
            return null;
        }
    	
        MonitorPerfControllerHome home;
        try {
            home = (MonitorPerfControllerHome) m_ctx
                    .lookup(MonitorPerfControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        	e.printStackTrace();
        } catch (RemoteException e) {
        	e.printStackTrace();
        } catch (CreateException e) {
        	e.printStackTrace();
        }
        m_ctx = null;
        return null;
    }
    
    private NamingContext getContext() throws NamingException {
    	NamingContext namingContext = LoginManager.getContextManager().getNamingContext();
        
        return namingContext;
    }

//    /**
//     * 接続先URLを取得します。
//     * 
//     * @return String 接続先URL
//     */
//    private String getUrl() {
//    	String url = null;
//    	
//        //リソースストアから接続先URLを取得
//    	if(ClusterControlPlugin.getDefault() != null){
//    		IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
//            url = store.getString(KEY_EJB_URL);
//            if (url.compareTo("") == 0) {
//                url = VALUE_EJB_URL;
//            }
//    	}
//    	
//        return url;
//    }
}