/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.view;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.clustercontrol.performance.composite.CollectionListComposite;
import com.clustercontrol.performance.composite.action.CurrentListSelectionChangedListener;
import com.clustercontrol.performance.view.action.DeleteCollectedDataAction;
import com.clustercontrol.performance.view.action.ExportCollectedDataAction;
import com.clustercontrol.performance.view.action.RestartCollectorAction;
import com.clustercontrol.performance.view.action.ShowPropertyAction;
import com.clustercontrol.performance.view.action.StopCollectorAction;
import com.clustercontrol.performance.view.action.SuspendCollectorAction;
import com.clustercontrol.performance.view.action.ViewCurrentGraphAction;
import com.clustercontrol.performance.bean.CollectorRunStatus;
import com.clustercontrol.view.CommonViewPart;

/**
 * 収集中の収集設定のステータスのリストを表示するViewクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public class CurrentListView extends CommonViewPart {
    public static final String ID = "com.clustercontrol.performance.view.CurrentListView";

    //	 ----- instance フィールド ----- //

    /** 収集一覧コンポジット */
    private CollectionListComposite tableComposite = null;

    //	 ----- コンストラクタ ----- //

    //	 ----- instance メソッド ----- //
    
    /**
     * 収集一覧テーブルを作成・追加します。
     * 
     * @param parent 親のコンポジット
     */
    @Override
	public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        this.tableComposite = new CollectionListComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.tableComposite.setLayoutData(gridData);
        
        this.tableComposite.getTableViewer().addSelectionChangedListener(
        		new CurrentListSelectionChangedListener());
        
//        tableComposite.getTableViewer().getTable().addSelectionListener(
//        new SelectionAdapter(){
//			public void widgetSelected(SelectionEvent e) {
//				// 収集一覧テーブルで選択さている収集の状態により
//				// ビューのボタンの有効/無効を設定する
//				setEnabledAction(tableComposite.getRunStatus());
//			}
//        });
        
        this.refresh();
    }

    /**
     * ビューを更新します。
     */
    public void refresh() {
        this.tableComposite.update();
    }

    /**
     * 現在選択されている収集IDを返します。
     *
     * @return 現在選択されている収集のCollectorID
     */
    public String getSelectedID() {
        return tableComposite.getSelectedID();
    }
    
    /**
     * ビューのアクションの有効/無効を設定
     * 
     * @param status 実績収集の実行状態
	 * @param selection ボタン（アクション）を有効にするための情報
     * @since 1.0
     */
    public void setEnabledAction(int status, ISelection selection) {
        // ビューアクションの使用可/不可を設定
    	super.setEnabledAction(SuspendCollectorAction.ID, selection);
    	super.setEnabledAction(RestartCollectorAction.ID, selection);
    	super.setEnabledAction(StopCollectorAction.ID, selection);
    	super.setEnabledAction(ShowPropertyAction.ID, selection);
    	super.setEnabledAction(ViewCurrentGraphAction.ID, selection);
    	super.setEnabledAction(ExportCollectedDataAction.ID, selection);
    	super.setEnabledAction(DeleteCollectedDataAction.ID, selection);  	
    	
    	if (status == CollectorRunStatus.RUNNING) {
        	super.setEnabledAction(SuspendCollectorAction.ID   , true);
        	super.setEnabledAction(RestartCollectorAction.ID   , false);
        	super.setEnabledAction(StopCollectorAction.ID      , true);
        	super.setEnabledAction(ShowPropertyAction.ID       , true);
        	super.setEnabledAction(ViewCurrentGraphAction.ID   , true);
        	super.setEnabledAction(ExportCollectedDataAction.ID, true);
        	super.setEnabledAction(DeleteCollectedDataAction.ID, false);
        } else if (status == CollectorRunStatus.FINISHED) {
           	super.setEnabledAction(SuspendCollectorAction.ID   , false);
        	super.setEnabledAction(RestartCollectorAction.ID   , false);
        	super.setEnabledAction(StopCollectorAction.ID      , false);
        	super.setEnabledAction(ShowPropertyAction.ID       , true);
        	super.setEnabledAction(ViewCurrentGraphAction.ID   , true);
        	super.setEnabledAction(ExportCollectedDataAction.ID, true);
        	super.setEnabledAction(DeleteCollectedDataAction.ID, true);
        } else if (status == CollectorRunStatus.SUSPEND) {
        	super.setEnabledAction(SuspendCollectorAction.ID   , false);
        	super.setEnabledAction(RestartCollectorAction.ID   , true);
        	super.setEnabledAction(StopCollectorAction.ID      , true);
        	super.setEnabledAction(ShowPropertyAction.ID       , true);
        	super.setEnabledAction(ViewCurrentGraphAction.ID   , true);
        	super.setEnabledAction(ExportCollectedDataAction.ID, true);
        	super.setEnabledAction(DeleteCollectedDataAction.ID, false);
        } else if (status == CollectorRunStatus.ERROR) {
        	super.setEnabledAction(SuspendCollectorAction.ID   , false);
        	super.setEnabledAction(RestartCollectorAction.ID   , true);
        	super.setEnabledAction(StopCollectorAction.ID      , true);
        	super.setEnabledAction(ShowPropertyAction.ID       , true);
        	super.setEnabledAction(ViewCurrentGraphAction.ID   , true);
        	super.setEnabledAction(ExportCollectedDataAction.ID, true);
        	super.setEnabledAction(DeleteCollectedDataAction.ID, false);
        }
    }
}