/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.ping.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.transaction.InvalidTransactionException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.ping.ejb.session.MonitorPingController;
import com.clustercontrol.ping.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ping監視情報を削除するクライアント側アクションクラス<BR>
 * 
 * @version 3.0.0
 * @since 2.0.0
 */
public class DeletePing {

    /**
     * ping監視情報を削除します。<BR>
     * 
     * @param monitorId 監視項目ID
     * @return 削除に成功した場合、true
     */
    public boolean delete(String monitorId) {
    	
    	MonitorPingController ping = EjbConnectionManager.getConnectionManager().getPingController();

        boolean result = false;
        try {
        	result = ping.deletePing(monitorId);
        	return result;
        	
        } catch (InvalidTransactionException e) {
        } catch (IllegalStateException e) {
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (MonitorNotFoundException e) {
		} catch (HinemosUnknownException e) {
		}
        return false;
    }
}