/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.port.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.port.ejb.session.MonitorPortController;
import com.clustercontrol.port.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * port監視を取得するクラスです。
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class GetPort {

    /**
     * port監視情報を返します。
     * 
     * @param monitorId 監視項目ID
     * @return port監視情報
     */
    public MonitorInfo getPort(String monitorId) {

    	MonitorPortController port = EjbConnectionManager.getConnectionManager().getPortController();

    	MonitorInfo info = null;
        try {
        	info = port.getPort(monitorId);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (MonitorNotFoundException e) {
		} catch (HinemosUnknownException e) {
		}
        return info;
    }
    
    /**
     * port監視一覧を返します。
     * 
     * @return port監視一覧
     */
    public ArrayList<MonitorInfo> getPortList() {

    	MonitorPortController port = EjbConnectionManager.getConnectionManager()
                .getPortController();

        ArrayList<MonitorInfo> records = null;
        try {
            records = port.getPortList();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (MonitorNotFoundException e) {
		} catch (HinemosUnknownException e) {
		}
        return records;
    }
}