/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * スコープへのノード割り当てを解除を行うクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ReleaseNode {

    // ----- instance メソッド ----- //

    /**
     * スコープscopeIdに対して、ノードnodeIdの割り当てを解除します。<BR>
     * 
     * @param scopeId
     *            対象スコープのファシリティID
     * @param nodeId
     *            割り当てられているノードのファシリティID
     * @return 正常に終了した場合、true
     */
    public boolean release(String scopeId, String[] nodeId) {
        RepositoryController repository = EjbConnectionManager
                .getConnectionManager().getRepositoryController();

        boolean result = false;
        try {
        	// メイン処理
            repository.releaseNodeScope(scopeId, nodeId);
   			result = true;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        }
		// リポジトリキャッシュの更新
		if(result)
			FacilityTree.reflesh();
		
        return result;
    }
}