/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.sql.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.monitor.run.bean.MonitorTabelDefine;
import com.clustercontrol.monitor.run.bean.StringValueListTabelDefine;
import com.clustercontrol.util.Messages;

/**
 * SQL監視 文字列監視判定一覧テーブル定義情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetSqlStringValueListTableDefine {

    /**
     * SQL監視一覧のテーブル定義情報を返します。
     * 
     * @return SQL監視一覧テーブル定義情報
     */
    public static ArrayList<TableColumnInfo> get() {
    	// テーブル情報定義配列
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
		Locale locale = Locale.getDefault();
		
		tableDefine.add(StringValueListTabelDefine.ORDER_NO, 
				new TableColumnInfo(Messages.getString("order", locale), TableColumnInfo.NONE, 40, SWT.RIGHT));
		tableDefine.add(StringValueListTabelDefine.PROCESS_TYPE, 
				new TableColumnInfo(Messages.getString("process", locale), TableColumnInfo.PROCESS, 50, SWT.LEFT));
		tableDefine.add(StringValueListTabelDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 180, SWT.LEFT));
		tableDefine.add(StringValueListTabelDefine.VALID_FLG, 
				new TableColumnInfo(Messages.getString("valid", locale) + "/" + Messages.getString("invalid", locale), TableColumnInfo.VALID, 80, SWT.LEFT));;
		tableDefine.add(StringValueListTabelDefine.MESSAGE_ID, 
				new TableColumnInfo(Messages.getString("message.id", locale), TableColumnInfo.NONE, 90, SWT.LEFT));
		
		return tableDefine;
    }
}