/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performance.bean;

import java.io.Serializable;
import java.util.Date;

/**
 * 収集した性能値を格納するDTOクラス
 * 
 * 収集日時と性能値をペアで保持します。
 * 
 * @version 3.0
 * @since 3.0
 *
 */
public class CollectedDataInfo implements Serializable {
	private static final long serialVersionUID = -126607156053910561L;

	private final String m_itemCode;      //収集項目コード
	private final String m_displayName;    //リポジトリ表示名
	private Date m_dateTime;        //収集日時
	private final String m_facilityId;    //ファシリティID
	private final double m_value;         //性能値
	private final int m_errorType;        //値が不正な場合のエラーパターン

	/**
	 * ファシリティID, 収集項目ID, デバイス名, 性能値を格納したCollectedDataInfoオブジェクトを生成します。<br>
	 * 
	 * @param facilityId ファシリティID
	 * @param itemCode 収集項目ID
	 * @param deviceName デバイス名
	 * @param value 性能値
	 */
	public CollectedDataInfo(final String facilityId, final String itemCode, final String displayName, final Date date, final double value) {
		this.m_facilityId = facilityId;
		this.m_itemCode = itemCode;
		this.m_displayName = displayName;
		this.m_dateTime = date;
		this.m_value = value;
		this.m_errorType = CollectedDataErrorTypeConstant.NOT_ERROR;
	}
	
	/**
	 * 性能値の算出に失敗した場合のインスタンスを生成します。
	 * ファシリティID, 収集項目ID, デバイス名, 性能値を格納したCollectedDataInfoオブジェクトを生成します。<br>
	 * 格納される性能値は、Double.NaNとなります。
	 * 
	 * @param facilityId ファシリティID
	 * @param itemCode 収集項目ID
	 * @param deviceName デバイス名
	 * @param errorType エラー種別
	 */
	public CollectedDataInfo(final String facilityId, final String itemCode, final String displayName, final Date date, final int errorType) {
		this.m_facilityId = facilityId;
		this.m_itemCode = itemCode;
		this.m_displayName = displayName;
		this.m_dateTime = date;
		this.m_value = Double.NaN;
		this.m_errorType = errorType;
	}
	
	/**
	 * ファシリティID, 収集項目ID, デバイス名, 性能値を格納したCollectedDataInfoオブジェクトを生成します。<br>
	 * その他のインスタンス変数は未定義です。
	 * 
	 * @param facilityId ファシリティID
	 * @param itemCode 収集項目ID
	 * @param deviceName デバイス名
	 * @param value 性能値
	 * 
	 * @author NTT DATA takahatat
	 */
//	public CollectedDataInfo(final String facilityId, final String itemCode, final String deviceName, final String collectMethod) {
////		this.m_facilityId = facilityId;
////		this.m_itemCode = itemCode;
////		this.m_deviceName = deviceName;
////		this.m_collectMethod = collectMethod;
//		this(facilityId, itemCode, deviceName, collectMethod, null, 0);
//	}
	
	/**
	 * 指定された、ファシリティID、収集項目IDを格納したCollectedDataInfoオブジェクトを生成します。
	 * 
	 * @param facilityID ファシリティID
	 * @param deviceIndex 収集項目ID
	 */
//	public CollectedDataInfo(final String facilityId, final String itemCode, final int deviceIndex, final String deviceName){
//		this.m_facilityId = facilityId;
//		this.m_itemCode = itemCode;
//		//this.m_deviceIndex = deviceIndex;
//		this.m_deviceName = deviceName;
//	}
	
//	/**
//	 * 指定された、ファシリティID、収集項目IDを格納したCollectedDataInfoオブジェクトを生成します。
//	 * 
//	 * @param facilityID ファシリティID
//	 * @param collectorItemID 収集項目ID
//	 */
//	public CollectedDataInfo(final String facilityId, final int collectorItemID){
//		m_facilityId = facilityId;
//		//m_collectorItemID = collectorItemID;
//	}
//	
//	/**
//	 * 指定されたCollectedDataInfoインスタンスをもとにCollectedDataInfoオブジェクトを生成します。
//	 * 
//	 * @param collectorItemInfo 収集項目設定情報
//	 */
//	public CollectedDataInfo(final CollectorItemInfo collectorItemInfo){
//		m_collectorId = collectorItemInfo.getCollectorID();
//	}
	
	/**
	 * 指定された、ファシリティID、収集項目ID、収集日時、性能値を格納したCollectedDataInfoオブジェクトを生成します。
	 * 
	 * @param facilityID ファシリティID
	 * @param collectorItemID 収集項目ID
	 * @param date 日時
	 * @param value 性能値
	 */
//	public CollectedDataInfo(final String facilityId, final int collectorItemID, final Date date, final double value){
//		m_facilityId = facilityId;
//		//m_collectorItemID = collectorItemID;
//		m_dateTime = date;
//		m_value = value;
//	}
	
	/**
	 * 指定された、CollectedDataInfoと同じ値を保持するオブジェクトを生成します。
	 * 
	 * @param dataInfo 収集したデータセット
	 */
//	public CollectedDataInfo(final CollectedDataInfo dataInfo){
//		m_facilityId = dataInfo.getFacilityId();
//		//m_collectorItemID = dataInfo.getCollectorItemID();
//		m_dateTime = dataInfo.getDate();
//		m_value = dataInfo.getValue();
//	}

//	/**
//	 * 収集ID を取得します。
//	 * @return 収集ID
//	 */
//	public String getCollectorId() {
//		return m_collectorId;
//	}
//	/**
//	 * collectorId を設定します。
//	 * @param collectorId 収集ID
//	 */
//	public void setCollectorId(String collectorId) {
//		m_collectorId = collectorId;
//	}

//	/**
//	 * 収集方法 を取得します。
//	 * @return 収集方法
//	 */
//	public String getCollectMethod() {
//		return m_collectMethod;
//	}
//	/**
//	 * collectMethod を設定します。
//	 * @param collectMethod 収集方法
//	 */
//	public void setCollectMethod(String collectMethod) {
//		m_collectMethod = collectMethod;
//	}

	
	
	/**
	 * 収集項目コードを取得します。
	 * @return 収集項目コード
	 */
	public String getItemCode() {
		return m_itemCode;
	}

//	/**
//	 * 収集項目コードを設定します。
//	 * @param itemCode 収集項目コード
//	 */
//	public void setItemCode(String itemCode) {
//		this.m_itemCode = itemCode;
//	}
	
	/**
	 * リポジトリ表示名を取得します。
	 * @return
	 */
	public String getDisplayName() {
		return m_displayName;
	}
//	/**
//	 * デバイス名を設定します。
//	 * @param deviceName デバイス名
//	 */
//	public void setDeviceName(String deviceName) {
//		m_deviceName = deviceName;
//	}
	
	/**
	 * 収集日時 を取得します。
	 * @return 収集日時
	 */
	public Date getDate() {
		return m_dateTime;
	}

//	/**
//	 * 日時 を設定します。
//	 * @param date 日時 
//	 */
//	public void setDate(Date date) {
//		m_dateTime = date;
//	}

	/**
	 * ファシリティID を取得します。
	 * @return ファシリティID
	 */
	public String getFacilityId() {
		return m_facilityId;
	}
//	/**
//	 * facilityID を設定します。
//	 * @param facilityid ファシリティID
//	 */
//	public void setFacilityId(String facilityId) {
//		m_facilityId = facilityId;
//	}
	
	/**
	 * 性能値 を取得します。
	 * @return  性能値
	 */
	public double getValue() {
		return m_value;
	}
//	/**
//	 * 性能値 を設定します。
//	 * @param value 性能値
//	 */
//	public void setValue(double value) {
//		m_value = value;
//	}
	
	/**
	 * エラー種別を返します。
	 */
	public int getErrorType(){
		return m_errorType;
	}

	/**
	 * データの内容を文字列として返します。
	 */
	@Override
	public String toString(){
		String str =
			"FID:" + m_facilityId + 
			"  Item:" +  m_itemCode +
			"." + m_displayName +
			"  " + m_dateTime + 
			" : " + m_value;
		return str;
	}

	public void setDate(Date time) {
		m_dateTime = time;
	}
}