/* 
  
Copyright (C) since 2009 NTT DATA Corporation 
  
This program is free software; you can redistribute it and/or 
Modify it under the terms of the GNU General Public License  
as published by the Free Software Foundation, version 2. 
  
This program is distributed in the hope that it will be 
 useful, but WITHOUT ANY WARRANTY; without even the implied  
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR  
 PURPOSE.  See the GNU General Public License for more details. 
  
*/ 
package com.clustercontrol.repository.bean;

import java.io.Serializable;

/**
 * このクラスは、リポジトリプロパティ[デバイス]のクラスです。
 * NodeDataクラスのメンバ変数として利用されます。
 * @since 0.8
 */
public class NodeDeviceInfo implements Serializable
{
	private java.lang.String deviceType = "";
	private java.lang.Integer deviceIndex = new Integer(-1);
	private java.lang.String deviceName = "";
	private java.lang.String deviceDisplayName = "";
	private java.lang.String deviceSnmpOid = "";
	private java.lang.String deviceDescription = "";

	/**
	 * 空のコンストラクタです。setterで要素を追加して下さい。
	 */
	public NodeDeviceInfo()
	{
	}

	
	/**
	 * コンストラクトする際に、値をセットする事ができます。
	 * @param deviceType
	 * @param deviceIndex
	 * @param deviceName
	 * @param deviceDisplayName
	 * @param deviceSnmpOid
	 * @param deviceDescription
	 */
	public NodeDeviceInfo(java.lang.String deviceType,java.lang.Integer deviceIndex,java.lang.String deviceName,java.lang.String deviceDisplayName,java.lang.String deviceSnmpOid,java.lang.String deviceDescription )
	{
		setDeviceType(deviceType);
		setDeviceIndex(deviceIndex);
		setDeviceName(deviceName);
		setDeviceDisplayName(deviceDisplayName);
		setDeviceSnmpOid(deviceSnmpOid);
		setDeviceDescription(deviceDescription);
	}
	
	/**
	 * NodeDeviceDataインスタンスのコピーを生成する時に利用します。
	 * @param otherData
	 */
	public NodeDeviceInfo( NodeDeviceInfo otherData )
	{
		setDeviceType(otherData.getDeviceType());
		setDeviceIndex(otherData.getDeviceIndex());
		setDeviceName(otherData.getDeviceName());
		setDeviceDisplayName(otherData.getDeviceDisplayName());
		setDeviceSnmpOid(otherData.getDeviceSnmpOid());
		setDeviceDescription(otherData.getDeviceDescription());

	}

	/**
	 * DeviceTypeのgetterです。
	 * @return String
	 */
	public java.lang.String getDeviceType()
	{
		return this.deviceType;
	}
	
	/**
	 * デバイス種別のsetterです。
	 * デバイス種別はnot nullです。disk, nic等をセットします。
	 * @param deviceType
	 */
	public void setDeviceType( java.lang.String deviceType )
	{
		this.deviceType = deviceType;
	}

	/**
	 * デバイスINDEXのgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getDeviceIndex()
	{
		return this.deviceIndex;
	}
	
	/**
	 * デバイスINDEXのsetterです。デバイスINDEXはnot nullです。
	 * @param deviceIndex
	 */
	public void setDeviceIndex( java.lang.Integer deviceIndex )
	{
		this.deviceIndex = deviceIndex;
	}

	/**
	 * デバイス名のgetterです。
	 * @return String
	 */
	public java.lang.String getDeviceName()
	{
		return this.deviceName;
	}
	
	/**
	 * デバイス名のsetterです。デバイス名はnot nullです。
	 * @param deviceName
	 */
	public void setDeviceName( java.lang.String deviceName )
	{
		this.deviceName = deviceName;
	}

	/**
	 * デバイス表示名のgetterです。
	 * @return String
	 */
	public java.lang.String getDeviceDisplayName()
	{
		return this.deviceDisplayName;
	}
	
	/**
	 * デバイス表示名のsetterです。デバイス表示名はnot nullです。
	 * @param deviceDisplayName
	 */
	public void setDeviceDisplayName( java.lang.String deviceDisplayName )
	{
		this.deviceDisplayName = deviceDisplayName;
	}

	/**
	 * デバイスOIDのgetterです。
	 * @return String
	 */
	public java.lang.String getDeviceSnmpOid()
	{
		return this.deviceSnmpOid;
	}
	
	/**
	 * デバイスOIDのsetterです。
	 * @param deviceSnmpOid
	 */
	public void setDeviceSnmpOid( java.lang.String deviceSnmpOid )
	{
		this.deviceSnmpOid = deviceSnmpOid;
	}

	/**
	 * デバイス説明のsetterです。
	 * @return String
	 */
	public java.lang.String getDeviceDescription()
	{
		return this.deviceDescription;
	}
	
	/**
	 * デバイス説明のgetterです。
	 * @param deviceDescription
	 */
	public void setDeviceDescription( java.lang.String deviceDescription )
	{
		this.deviceDescription = deviceDescription;
	}

	@Override
	public String toString()
	{
		StringBuffer str = new StringBuffer("{");

		str.append("deviceType=" + getDeviceType() + " " + "deviceIndex=" + getDeviceIndex() + " " + "deviceName=" + getDeviceName() + " " + "deviceDisplayName=" + getDeviceDisplayName() + " " + "deviceSnmpOid=" + getDeviceSnmpOid() + " " + "deviceDescription=" + getDeviceDescription());
		str.append('}');

		return(str.toString());
	}

	@Override
	public boolean equals( Object pOther )
	{
		if( pOther instanceof NodeDeviceInfo )
		{
			NodeDeviceInfo lTest = (NodeDeviceInfo) pOther;
			boolean lEquals = true;

			if( this.deviceType == null )
			{
				lEquals = lEquals && ( lTest.deviceType == null );
			}
			else
			{
				lEquals = lEquals && this.deviceType.equals( lTest.deviceType );
			}
			if( this.deviceIndex == null )
			{
				lEquals = lEquals && ( lTest.deviceIndex == null );
			}
			else
			{
				lEquals = lEquals && this.deviceIndex.equals( lTest.deviceIndex );
			}
			if( this.deviceName == null )
			{
				lEquals = lEquals && ( lTest.deviceName == null );
			}
			else
			{
				lEquals = lEquals && this.deviceName.equals( lTest.deviceName );
			}
			if( this.deviceDisplayName == null )
			{
				lEquals = lEquals && ( lTest.deviceDisplayName == null );
			}
			else
			{
				lEquals = lEquals && this.deviceDisplayName.equals( lTest.deviceDisplayName );
			}
			if( this.deviceSnmpOid == null )
			{
				lEquals = lEquals && ( lTest.deviceSnmpOid == null );
			}
			else
			{
				lEquals = lEquals && this.deviceSnmpOid.equals( lTest.deviceSnmpOid );
			}
			if( this.deviceDescription == null )
			{
				lEquals = lEquals && ( lTest.deviceDescription == null );
			}
			else
			{
				lEquals = lEquals && this.deviceDescription.equals( lTest.deviceDescription );
			}

			return lEquals;
		}
		else
		{
			return false;
		}
	}

	@Override
	public int hashCode()
	{
		int result = 17;

		result = 37*result + ((this.deviceType != null) ? this.deviceType.hashCode() : 0);

		result = 37*result + ((this.deviceIndex != null) ? this.deviceIndex.hashCode() : 0);

		result = 37*result + ((this.deviceName != null) ? this.deviceName.hashCode() : 0);

		result = 37*result + ((this.deviceDisplayName != null) ? this.deviceDisplayName.hashCode() : 0);

		result = 37*result + ((this.deviceSnmpOid != null) ? this.deviceSnmpOid.hashCode() : 0);

		result = 37*result + ((this.deviceDescription != null) ? this.deviceDescription.hashCode() : 0);

		return result;
	}

}
