/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.ejb.entity;


/**
 *
 * 一括制御コマンドのパラメータ情報（選択式）を持つEntity Beanです。
 * 
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="CRunParamSelectMst"
 *    jndi-name="CRunParamSelectMst"
 *    type="CMP"
 *    view-type="local"
 *    schema="CRunParamSelectMst" 
 *    cmp-version="2.x"
 *    data-source="java:/HinemosDS"
 * 
 * @ejb.persistence 
 *    table-name="cc_crun_param_select_mst" 
 * 
 * @ejb.pk 
 *    class="com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstPK"
 * 
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_crun_param_select_mst"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.depends 
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CRunParamSelectMst as a"  
 *    signature="java.util.Collection findAll()"  
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CRunParamSelectMst as a WHERE a.param_id = ?1"  
 *    signature="java.util.Collection findByParamId(java.lang.String param_id)"  
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CRunParamSelectMst as a WHERE a.param_id = ?1 AND a.name_id = ?2"  
 *    signature="java.util.Collection findByNameId(java.lang.String param_id, java.lang.String name_id)"  
 * 
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public abstract class CRunParamSelectMstBean implements javax.ejb.EntityBean {
    
    /**
     *
     * <!-- begin-user-doc -->
     * The  ejbCreate method.
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     * @ejb.create-method 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public CRunParamSelectMstPK ejbCreate(
            String param_id, 
            Integer order_no, 
            String name_id, 
            String param_value) throws javax.ejb.CreateException {
        setParam_id(param_id);
        setOrder_no(order_no);
        setName_id(name_id);
        setParam_value(param_value);
        return null;
    }
    
    /**
     * <!-- begin-user-doc -->
     * The container invokes this method immediately after it calls ejbCreate.
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    public void ejbPostCreate() throws javax.ejb.CreateException {
        // begin-user-code
        // end-user-code
    }
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field param_id
     *
     * Returns the param_id
     * @return the param_id
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="param_id"
     *     jdbc-type="VARCHAR"
     *     sql-type="VARCHAR"
     *     read-only="false"
     * @ejb.pk-field 
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.String getParam_id();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the param_id
     * 
     * @param java.lang.String the new param_id value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setParam_id(java.lang.String param_id);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field order_no
     *
     * Returns the order_no
     * @return the order_no
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="order_no"
     *     jdbc-type="SMALLINT"
     *     sql-type="SMALLINT"
     *     read-only="false"
     * @ejb.pk-field 
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.Integer getOrder_no();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the order_no
     * 
     * @param java.lang.Integer the new order_no value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setOrder_no(java.lang.Integer order_no);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field name_id
     *
     * Returns the name_id
     * @return the name_id
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="name_id"
     *     jdbc-type="VARCHAR"
     *     sql-type="VARCHAR"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.String getName_id();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the name_id
     * 
     * @param java.lang.String the new name_id value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setName_id(java.lang.String name_id);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field param_value
     *
     * Returns the param_value
     * @return the param_value
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="param_value"
     *     jdbc-type="VARCHAR"
     *     sql-type="VARCHAR"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.String getParam_value();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the param_value
     * 
     * @param java.lang.String the new param_value value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setParam_value(java.lang.String param_value);
    
    //	==========================================
    //	 CMR fields
    //	==========================================
    /**
     * @ejb.interface-method view-type="local"
     * 
     * @ejb.relation 
     * name="CRunParamMst-CRunParamSelectMst"
     * role-name="CRunParamSelectMst-CRunParamMst(multi)"
     * 
     * @jboss.relation
     * related-pk-field="param_id"
     * fk-column="param_id"
     */
    public abstract CRunParamMstLocal getParamMst();
    
    /**
     * 
     * @ejb.interface-method view-type="local"
     */
    public abstract void setParamMst(CRunParamMstLocal paramMst);
}
