/*
                                                                                                
Copyright (C) since 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.performance.factory;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstPK;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstUtil;

/**
 * 収集毎の計算方法マスタ情報追加クラス
 * 
 * @version 1.2.0
 * @since 1.2.0
 * @author uchiyama
 *
 */
public class OperateCollectItemCalcMethodMaster {
	
	protected static Log m_log = LogFactory.getLog( OperateCollectItemCalcMethodMaster.class );
	
	/**
	 * 収集毎の計算方法マスタ情報を追加します。
	 * 
	 * @param data 収集毎の計算方法情報
	 * @return 成功した場合、true
	 * @throws NamingException 
	 * @throws CreateException 
	 * @throws EJBException
	 */
	public boolean add(CollectorItemCalcMethodMstData data) throws CreateException, NamingException, EJBException {
		
		try {
			// 収集毎の計算方法情報の追加
			CollectorItemCalcMethodMstUtil.getLocalHome().create(
					data.getCollectMethod(),
					data.getPlatformId(),
					data.getSubPlatformId(),
					data.getItemCode(),
					data.getCalcMethod()
			);
		}
		catch (CreateException e){
			throw e;
		}
		catch (EJBException e) {
			throw e;
		}

		return true;
	}
	
	/**
	 * 収集毎の計算方法マスタ情報を追加します。
	 * 
	 * @param data 収集毎の計算方法情報
	 * @return 成功した場合、true
	 * @throws NamingException 
	 * @throws CreateException 
	 * 
	 */
	public boolean addSql(CollectorItemCalcMethodMstData data) throws CreateException, NamingException{
		
		m_log.debug("insert CollectorItemCalcMst() start :"
				+ data.getCollectMethod() + " "
				+ data.getPlatformId() + " "
				+ data.getSubPlatformId() + " "
				+ data.getItemCode() + " "
				+ data.getCalcMethod());
				
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try{
			conn = ConnectionManager.getConnectionManager().getConnection();
			//		SQL文の作成
			//SQL文の定義
			String sql = "INSERT INTO CC_COLLECTOR_ITEM_CALC_METHOD_MST " +
			"(collect_method, " +
			"platform_id," +
			"sub_platform_id," +
			"item_code," +
			"calc_method)" +
			"values (?,?,?,?,?);";
			
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, data.getCollectMethod());
			stmt.setString(2, data.getPlatformId());
			stmt.setString(3, data.getSubPlatformId());
			stmt.setString(4, data.getItemCode());
			stmt.setString(5, data.getCalcMethod());
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("insertCollectorItemMethodMst() error :" + data.toString() + " SQLException " + msg);
				
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			throw new CreateException(e.getMessage());
		}  finally{
			
			//コネクション、結果セット、プリペアドステートメントのクロース
			try {
				if(stmt != null){
					stmt.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("insertCollectorItemMethodMst() error :" + data.toString() + " SQLException ");
				throw new EJBException(e1.getMessage());
			}
			
			m_log.debug("insertCollectorItem() end   :" + data.toString());
		}
			
		return true;
	}
	
	/**
	 * 収集毎の計算方法マスタ情報を削除します。
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws RemoveException 
	 * @throws EJBException 
	 */
	public boolean delete(CollectorItemCalcMethodMstPK pk) throws FinderException, NamingException, EJBException, RemoveException {
		
		CollectorItemCalcMethodMstLocal local = CollectorItemCalcMethodMstUtil.getLocalHome().findByPrimaryKey(pk);
		// pkが同じデータが登録されている場合は、削除する
		local.remove();
		
		return true;
	}
	
	/**
	 * 収集毎の計算方法マスタ情報を全て削除します。
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws RemoveException 
	 * @throws EJBException 
	 */
	public boolean deleteAll() throws FinderException, NamingException, EJBException, RemoveException {
		
		Collection<CollectorItemCalcMethodMstLocal> col = CollectorItemCalcMethodMstUtil.getLocalHome().findAll();
		Iterator<CollectorItemCalcMethodMstLocal> itr = col.iterator();
		
		while(itr.hasNext()){
			itr.next().remove();
		}
		
		return true;
	}
	
}
