/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.repository.ejb.session;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.repository.ejb.entity.CollectorPlatformMstData;
import com.clustercontrol.repository.ejb.entity.CollectorPlatformMstLocal;
import com.clustercontrol.repository.ejb.entity.CollectorPlatformMstUtil;
import com.clustercontrol.repository.factory.OperateCollectPlatformMaster;

/**
 * 収集項目マスタ情報を制御するSession Bean <BR>
 * @ejb.bean name="RepositoryCollectMasterController"
 *           jndi-name="RepositoryCollectMasterController"
 *           type="Stateless"
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"   
 *     
 */
public abstract class RepositoryCollectMasterControllerBean implements SessionBean {
	
	protected static Log m_log = LogFactory.getLog( RepositoryCollectMasterControllerBean.class );
	
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/** 
	 * プラットフォーム定義を登録します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @param data プラットフォーム定義情報
	 * @return 登録に成功した場合、true
	 * @throws NamingException 
	 * @throws CreateException 
	 */
	public boolean addCollectPlatformMaster(CollectorPlatformMstData data) throws CreateException, NamingException {

		// プラットフォーム定義情報を登録
		OperateCollectPlatformMaster ope = new OperateCollectPlatformMaster();
		
		boolean ret = false;
		
		try{
			ret = ope.add(data);
		}catch(CreateException e){
			m_log.warn("addCollectPlatformMaster() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw e;
		}catch(NamingException e){
			m_log.warn("addCollectPlatformMaster() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw e;
		}
		
		return ret;
		
	}
	
	/**
	 * 全プラットフォーム定義を取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 * 
	 * @return 全プラットフォーム定義
	 * @throws NamingException 
	 * @throws FinderException 
	 */
	public ArrayList<CollectorPlatformMstData> getCollectPlatformList() throws FinderException, NamingException {
		
		ArrayList<CollectorPlatformMstData> ret = new ArrayList<CollectorPlatformMstData>();
		
		Collection<CollectorPlatformMstLocal> list = CollectorPlatformMstUtil.getLocalHome().findAll();
		Iterator<CollectorPlatformMstLocal> itrList = list.iterator();
		while(itrList.hasNext()) {
			CollectorPlatformMstLocal local = itrList.next();
			
			CollectorPlatformMstData data = new CollectorPlatformMstData(
					local.getPlatformId(),
					local.getPlatformName(),
					local.getOrderNo());
			
			ret.add(data);
		}
		
		return ret;
	}
	
}
