/*
                                                                                                
Copyright (C) since 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.factory;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.repository.ejb.entity.CollectorPlatformMstData;
import com.clustercontrol.repository.ejb.entity.CollectorPlatformMstLocal;
import com.clustercontrol.repository.ejb.entity.CollectorPlatformMstUtil;

/**
 * プラットフォームマスタ情報操作クラス
 * 
 * @version 1.2.0
 * @since 1.2.0
 * @author uchiyama
 *
 */
public class OperateCollectPlatformMaster {
	
	protected static Log m_log = LogFactory.getLog( OperateCollectPlatformMaster.class );
	
	/**
	 * プラットフォームマスタ情報を追加します。
	 * 
	 * @param data プラットフォーム情報
	 * @return 成功した場合、true
	 * @throws NamingException 
	 * @throws CreateException 
	 * 
	 */
	public boolean add(CollectorPlatformMstData data) throws CreateException, NamingException {
		
		// 計算ロジック情報の追加
		CollectorPlatformMstUtil.getLocalHome().create(
				data.getPlatformId(),
				data.getPlatformName(),
				Short.parseShort(data.getOrderNo())
		);
				
		return true;
	}
	
	/**
	 * プラットフォームマスタ情報を更新します。
	 */
	public boolean modify(CollectorPlatformMstData data) {
		
		String pk = data.getPrimaryKey();
		
		try {
			CollectorPlatformMstLocal local = CollectorPlatformMstUtil.getLocalHome().findByPrimaryKey(pk);
			
		} catch (FinderException e) {

		} catch (NamingException e) {
			
		}
		
		return true;
	}
	
	/**
	 * プラットフォームマスタ情報を削除します。
	 */
	public boolean delete(String pk) {
		
		try {
			CollectorPlatformMstLocal local = CollectorPlatformMstUtil.getLocalHome().findByPrimaryKey(pk);
			// pkが同じデータが登録されている場合は、削除する
			local.remove();
			
		} catch (FinderException e) {

		} catch (NamingException e) {
			
		} catch (EJBException e) {

		} catch (RemoveException e) {

		}
		
		return true;
	}
	
}
