/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.hinemosagent.factory;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jms.server.destination.SubscriptionInfo;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
//import org.jboss.mq.Subscription;
//import org.jboss.mq.selectors.Selector;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoLocal;
import com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoPK;
import com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoUtil;
import com.clustercontrol.monitor.run.bean.MonitorJudgementInfo;
import com.clustercontrol.monitor.run.factory.RunMonitor;
import com.clustercontrol.monitor.run.factory.RunMonitorTruthValueType;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * Hinemos Agent監視を実行するクラス<BR>
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class RunMonitorAgent extends RunMonitorTruthValueType {
	
	protected static Log m_log = LogFactory.getLog( RunMonitorAgent.class );

	public static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	public static final String JOB_AGENT_OBJECT_NAME = "jboss.messaging.destination:name=clustercontrolJobManagementExecute,service=Topic";
	public static final String LOG_AGENT_OBJECT_NAME = "jboss.messaging.destination:name=clustercontrolLogtransferUpdate,service=Topic";
//	public static final String JOB_AGENT_OBJECT_NAME = "jboss.mq.destination:name=clustercontrol/JobManagement/execute,service=Topic";
//	public static final String LOG_AGENT_OBJECT_NAME = "jboss.mq.destination:name=clustercontrol/Logtransfer/update,service=Topic";
	public static final String OPERATION_NAME = "listAllSubscriptions";
	
	public static final String MESSAGE_ID_INFO = "001";
	public static final String MESSAGE_ID_WARNING = "002";
	public static final String MESSAGE_ID_CRITICAL = "003";
	public static final String MESSAGE_ID_UNKNOWN = "004";
	
	/** Agent監視情報 */
	protected MonitorAgentInfoLocal m_agent = null;
	/** ジョブエージェントチェック */
	protected int m_checkJobAgent = YesNoConstant.TYPE_YES;
	/** ログ転送エージェントチェック */
	protected int m_checkLogAgent = YesNoConstant.TYPE_YES;
	
	/** メッセージ */
	protected String m_message = null;
	
	protected String m_messageJobAgent = "";;
	protected boolean m_valueJobAgent = false;
	
	protected String m_messageLogAgent = "";;
	protected boolean m_valueLogAgent = false;
	
	/**
	 * コンストラクタ
	 * 
	 */
	public RunMonitorAgent() throws NamingException, JMSException, CreateException{
		super();
	}
	
	/**
	 * マルチスレッドを実現するCallableTaskに渡すためのインスタンスを作成するメソッド
	 * 
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#runMonitorInfo()
	 * @see com.clustercontrol.monitor.run.util.CallableTask
	 */
	@Override
	public RunMonitor createMonitorInstance() throws NamingException, JMSException, CreateException{
		return new RunMonitorAgent();
	}
	
	/**
	 * Hinemos ジョブエージェント・ログ転送エージェントをチェック
	 * 
	 * @param facilityId ファシリティID
	 * @return 値取得に成功した場合、true
	 */
	@Override
	public boolean collect(String facilityId) {
		boolean result = false;
		boolean resultJobAgent = false;
		boolean resultLogAgent = false;
		m_value = false;
		
		// 監視開始時刻を設定
		m_nodeDate = m_now.getTime();
		
		//ジョブエージェントチェック
		if(m_checkJobAgent == YesNoConstant.TYPE_YES)
			resultJobAgent = checkJobAgent(facilityId);
		
		//ログ転送エージェントチェック
		if(m_checkLogAgent == YesNoConstant.TYPE_YES)
			resultLogAgent = checkLogAgent(facilityId);
		
		//どちらか成功ならば、値は取得できたこととする
		if(resultJobAgent || resultLogAgent){
			result = true;
		}
		
		//チェック結果
		if(m_checkJobAgent == YesNoConstant.TYPE_YES && 
				m_checkLogAgent == YesNoConstant.TYPE_YES){
			//両方とも正常ならば、正常とする
			if(m_valueJobAgent && m_valueLogAgent){
				m_value = true;
			}
			m_message = m_messageJobAgent + "\n" + m_messageLogAgent;
		}
		else if(m_checkJobAgent == YesNoConstant.TYPE_YES){
			m_value = m_valueJobAgent;
			m_message = m_messageJobAgent;
		}
		else if(m_checkLogAgent == YesNoConstant.TYPE_YES){
			m_value = m_valueLogAgent;
			m_message = m_messageLogAgent;
		}
		
		return result;
	}
	
	/**
	 * Hinemos ジョブエージェントをチェック
	 * 
	 * @param facilityId ファシリティID
	 * @return 値取得に成功した場合、true
	 */
	public boolean checkJobAgent(String facilityId) {
		boolean result = false;
		boolean duplication = false;
		
		//値を初期化
		m_valueJobAgent = false;
		m_messageJobAgent = "";
		
		try{
	        InitialContext ic = new InitialContext();
	        
	        //RMIAdaptorを取得
	        RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

	        //ObjectNameを設定
	        ObjectName name = new ObjectName(JOB_AGENT_OBJECT_NAME);
	        
	        //ObjectNameのOperationNameのメソッドを実行
	        Object returnObject = server.invoke(name, OPERATION_NAME, null, null);

	        //結果をチェック
	        if(returnObject instanceof List){
		        //チェック文字列を作成
		        String checkString = "FacilityId='" + facilityId + "'";
	        
		        //同一ファシリティIDでのAgent重複起動チェック用
	        	HashMap<String, String> map = new HashMap<String, String>();
	        	
	        	for(int i = 0; i < ((List)returnObject).size(); i++){
	        		//SubscriptionInfo取得
	        		SubscriptionInfo subscription = (SubscriptionInfo)((List)returnObject).get(i);
        			String selecter = subscription.getSelector();
	        			
        			//Selectorとチェック文字列を比較
	        		if(selecter != null && 
	        				selecter.indexOf(checkString) != -1){
	        			//チェック文字列を含む場合
	        			//既に同じファシリティIDが存在しているかチェック
	        			if(map.get(facilityId) == null){
	        				//存在していない場合
		        			m_valueJobAgent = true;
		        			map.put(facilityId, facilityId);
	        			}
	        			else{
	        				//存在している場合
	        				m_valueJobAgent = false;
	        				duplication = true;
	        				
	        				//イベントに出力
	                        AplLogger apllog = new AplLogger("AGT","agt");
	                        String[] args = {facilityId};
	                        apllog.put("SYS","001", args);
	                        
	                        break;
	        			}
	        		}
	        	}
	        	
//	        	for(int i = 0; i < ((List)returnObject).size(); i++){
//	        		//Subscription取得
//	        		Subscription subscription = (Subscription)((List)returnObject).get(i);
//	        		
//	        		try {
//	        			//SubscriptionからSelectorを取得
//	        			Selector selecter = subscription.getSelector();
//	        			
//	        			//Selectorとチェック文字列を比較
//		        		if(selecter != null && 
//		        				selecter.selector.indexOf(checkString) != -1){
//		        			//チャック文字列を含む場合
//		        			
//		        			//既に同じファシリティIDが存在しているかチェック
//		        			if(map.get(facilityId) == null){
//		        				//存在していない場合
//			        			m_valueJobAgent = true;
//			        			map.put(facilityId, facilityId);
//		        			}
//		        			else{
//		        				//存在している場合
//		        				m_valueJobAgent = false;
//		        				duplication = true;
//		        				
//		        				//イベントに出力
//		                        AplLogger apllog = new AplLogger("AGT","agt");
//		                        String[] args = {facilityId};
//		                        apllog.put("SYS","001", args);
//		                        
//		                        break;
//		        			}
//		        		}
//					} catch (InvalidSelectorException e) {
//						m_log.debug("collect() : " + e.getMessage());
//					}
//	        	}
	        	
	        	
        		if(!duplication){
    	        	if(m_valueJobAgent){
    	        		//OK
    	        		m_messageJobAgent = Messages.getString("message.agent.1");
    	        	}
    	        	else{
    	        		//NG
    	        		m_messageJobAgent = Messages.getString("message.agent.2");
    	        	}
        		}
        		else{
        			//同一ファシリティのAgentの重複
        			String[] args = {facilityId};
    				m_messageJobAgent = Messages.getString("message.agent.3", args);
        		}
	        	
	        	result = true;
	        }
	        else{
	        	//値取得失敗
	        	m_messageJobAgent = Messages.getString("message.agent.4");
	        }
		} catch (NamingException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageJobAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (MalformedObjectNameException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageJobAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (NullPointerException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageJobAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (InstanceNotFoundException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageJobAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (MBeanException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageJobAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (ReflectionException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageJobAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (IOException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageJobAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		}

		return result;
	}

	/**
	 * Hinemos ログ転送エージェントをチェック
	 * 
	 * @param facilityId ファシリティID
	 * @return 値取得に成功した場合、true
	 */
	public boolean checkLogAgent(String facilityId) {
		boolean result = false;
		boolean duplication = false;
		
		//値を初期化
		m_valueLogAgent = false;
		m_messageLogAgent = "";
		
		try{
	        InitialContext ic = new InitialContext();
	        
	        //RMIAdaptorを取得
	        RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

	        //ObjectNameを設定
	        ObjectName name = new ObjectName(LOG_AGENT_OBJECT_NAME);
	        
	        //ObjectNameのOperationNameのメソッドを実行
	        Object returnObject = server.invoke(name, OPERATION_NAME, null, null);

	        //結果をチェック
	        if(returnObject instanceof List){
		        //チェック文字列を作成
		        String checkString = "FacilityId='" + facilityId + "'";
	        
		        //同一ファシリティIDでのAgent重複起動チェック用
	        	HashMap<String, String> map = new HashMap<String, String>();
	        	
	        	for(int i = 0; i < ((List)returnObject).size(); i++){
	        		//SubscriptionInfo取得
	        		SubscriptionInfo subscription = (SubscriptionInfo)((List)returnObject).get(i);
        			String selecter = subscription.getSelector();
        			
        			//Selectorとチェック文字列を比較
	        		if(selecter != null && 
	        				selecter.indexOf(checkString) != -1){
	        			//チャック文字列を含む場合
	        			
	        			//既に同じファシリティIDが存在しているかチェック
	        			if(map.get(facilityId) == null){
	        				//存在していない場合
		        			m_valueLogAgent = true;
		        			map.put(facilityId, facilityId);
	        			}
	        			else{
	        				//存在している場合
	        				m_valueLogAgent = false;
	        				duplication = true;
	        				
	        				//イベントに出力
	                        AplLogger apllog = new AplLogger("AGT","agt");
	                        String[] args = {facilityId};
	                        apllog.put("SYS","002", args);
	                        
	                        break;
	        			}
	        		}
	        	}
	        	
//	        	for(int i = 0; i < ((List)returnObject).size(); i++){
//	        		//Subscription取得
//	        		Subscription subscription = (Subscription)((List)returnObject).get(i);
//	        		
//	        		try {
//	        			//SubscriptionからSelectorを取得
//	        			Selector selecter = subscription.getSelector();
//	        			
//	        			//Selectorとチェック文字列を比較
//		        		if(selecter != null && 
//		        				selecter.selector.indexOf(checkString) != -1){
//		        			//チャック文字列を含む場合
//		        			
//		        			//既に同じファシリティIDが存在しているかチェック
//		        			if(map.get(facilityId) == null){
//		        				//存在していない場合
//			        			m_valueLogAgent = true;
//			        			map.put(facilityId, facilityId);
//		        			}
//		        			else{
//		        				//存在している場合
//		        				m_valueLogAgent = false;
//		        				duplication = true;
//		        				
//		        				//イベントに出力
//		                        AplLogger apllog = new AplLogger("AGT","agt");
//		                        String[] args = {facilityId};
//		                        apllog.put("SYS","002", args);
//		                        
//		                        break;
//		        			}
//		        		}
//					} catch (InvalidSelectorException e) {
//						m_log.debug("collect() : " + e.getMessage());
//					}
//	        	}
	        	
        		if(!duplication){
    	        	if(m_valueLogAgent){
    	        		//OK
    	        		m_messageLogAgent = Messages.getString("message.agent.5");
    	        	}
    	        	else{
    	        		//NG
    	        		m_messageLogAgent = Messages.getString("message.agent.6");
    	        	}
        		}
        		else{
        			//同一ファシリティのAgentの重複
        			String[] args = {facilityId};
    				m_messageLogAgent = Messages.getString("message.agent.7", args);
        		}
	        	
	        	result = true;
	        }
	        else{
	        	//値取得失敗
	        	m_messageLogAgent = Messages.getString("message.agent.4");
	        }
		} catch (NamingException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageLogAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (MalformedObjectNameException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageLogAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (NullPointerException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageLogAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (InstanceNotFoundException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageLogAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (MBeanException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageLogAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (ReflectionException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageLogAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (IOException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageLogAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		}

		return result;
	}
	
	/* (non-Javadoc)
	 * Hinemos Agent監視情報を設定
	 * @see com.clustercontrol.monitor.run.factory.OperationNumericValueInfo#setMonitorAdditionInfo()
	 */
	@Override
	public void setCheckInfo() throws FinderException, NamingException{
		
		// Agent監視情報を取得
		MonitorAgentInfoPK pk = new MonitorAgentInfoPK(m_monitorId, m_monitorTypeId);
		m_agent = MonitorAgentInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// Agent監視情報を設定
		if(m_agent.getCheckJobAgent() != null)
			m_checkJobAgent = m_agent.getCheckJobAgent().intValue();
		if(m_agent.getCheckLogAgent() != null)
			m_checkLogAgent = m_agent.getCheckLogAgent().intValue();
	}

	/* (non-Javadoc)
	 * ノード用メッセージIDを取得
	 * @see com.clustercontrol.monitor.run.factory.OperationMonitor#getMessageId(int)
	 */
	@Override
	public String getMessageId(int id) {

		MonitorJudgementInfo info = m_judgementInfoList.get(id);
		if(info != null){
			int priority = info.getPriority();
			if(priority == PriorityConstant.TYPE_INFO){
				return MESSAGE_ID_INFO;
			}
			else if(priority == PriorityConstant.TYPE_WARNING){
				return MESSAGE_ID_WARNING;
			}
			else if(priority == PriorityConstant.TYPE_CRITICAL){
				return MESSAGE_ID_CRITICAL;
			}
		}
		return MESSAGE_ID_UNKNOWN;
	}
	
	/* (non-Javadoc)
	 * ノード用メッセージを取得
	 * @see com.clustercontrol.monitor.run.factory.OperationMonitor#getMessage(int)
	 */
	@Override
	public String getMessage(int id) {
		return m_message;
	}

	/* (non-Javadoc)
	 * ノード用オリジナルメッセージを取得
	 * @see com.clustercontrol.monitor.run.factory.OperationMonitor#getMessageOrg(int)
	 */
	@Override
	public String getMessageOrg(int id) {
		return null;
	}

	/* (非 Javadoc)
	 * スコープ用メッセージIDを取得
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessageIdForScope(int)
	 */
	@Override
	public String getMessageIdForScope(int priority) {
		
		if(priority == PriorityConstant.TYPE_INFO){
			return MESSAGE_ID_INFO;
		}
		else if(priority == PriorityConstant.TYPE_WARNING){
			return MESSAGE_ID_WARNING;
		}
		else if(priority == PriorityConstant.TYPE_CRITICAL){
			return MESSAGE_ID_CRITICAL;
		}
		else{
			return MESSAGE_ID_UNKNOWN;
		}
	}
}
