/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

/**
 * ジョブファイル転送マスタのBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="JobFileMaster"
 *    jndi-name="JobFileMaster"
 *    type="BMP"
 *    view-type="local" 
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config BMP EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao
 *    class="com.clustercontrol.jobmanagement.dao.JobFileMasterDAO"
 *    impl-class="com.clustercontrol.jobmanagement.dao.JobFileMasterDAOImpl"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @see com.clustercontrol.jobmanagement.dao.JobFileMasterDAO
 * @see com.clustercontrol.jobmanagement.dao.JobFileMasterDAOImpl
 */
public abstract class JobFileMasterBean implements javax.ejb.EntityBean {
	/** 所属ジョブユニットのジョブID **/
	protected String jobunit_id;
	/** ジョブID */
	protected String job_id;
	/** スコープ処理方法 */
	protected Integer process_mode;
	/** 転送ファシリティID */
	protected String src_facility_id;
	/** 受信ファシリティID */
	protected String dest_facility_id;
	/** ファイル */
	protected String src_file;
	/** 転送作業ディレクトリ */
	protected String src_work_dir;
	/** 受信ディレクトリ */
	protected String dest_directory;
	/** 受信作業ディレクトリ */
	protected String dest_work_dir;
	/** ファイル圧縮 */
	protected Integer compression_flg; 
	/** ファイルチェック */
	protected Integer check_flg;
	/** 実効ユーザ */
	protected String effective_user;
	
	/**
	 * ジョブファイル転送マスタを生成します。
	 * 
	 * @ejb.create-method 
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 * @param job_id ジョブID
	 * @param process_mode スコープ処理方法
	 * @param src_facility_id 転送ファシリティID
	 * @param dest_facility_id 受信ファシリティID
	 * @param src_file ファイル
	 * @param src_work_dir 転送作業ディレクトリ
	 * @param dest_directory 受信ディレクトリ
	 * @param dest_work_dir 受信作業ディレクトリ
	 * @param compression_flg ファイル圧縮
	 * @param check_flg ファイルチェック
	 * @param effective_user 実効ユーザ
	 * @return プライマリーキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 * @see com.clustercontrol.bean.ProcessingMethodConstant
	 */
	public JobFileMasterPK ejbCreate(
			String jobunit_id,
			String job_id, 
			Integer process_mode, 
			String src_facility_id, 
			String dest_facility_id, 
			String src_file, 
			String src_work_dir, 
			String dest_directory, 
			String dest_work_dir, 
			Integer compression_flg, 
			Integer check_flg, 
			String effective_user
	) throws javax.ejb.CreateException {
		this.jobunit_id = jobunit_id;
		this.job_id = job_id;
		this.process_mode = process_mode;
		this.src_facility_id = src_facility_id;
		this.dest_facility_id = dest_facility_id;
		this.src_file = src_file;
		this.src_work_dir = src_work_dir;
		this.dest_directory = dest_directory;
		this.dest_work_dir = dest_work_dir;
		this.compression_flg = compression_flg;
		this.check_flg = check_flg;
		this.effective_user = effective_user;
		return null;
	}

	/**
	 * 全てのジョブファイル転送マスタを検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobFileMasterDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するジョブファイル転送マスタを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobFileMasterDAOImpl#findByPrimaryKey(JobFileMasterPK)
	 */
	public JobFileMasterPK ejbFindByPrimaryKey(JobFileMasterPK pk) throws FinderException {
		return null;
	}
	
	/**
	 * 所属ジョブユニットのジョブIDを返す。<BR>
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 所属ジョブユニットのジョブID
	 */
	public java.lang.String getJobunit_id() {
		return jobunit_id;
	}
	
	/**
	 * 所属ジョブユニットのジョブIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 */
	public void setJobunit_id(java.lang.String jobunit_id) {
		this.jobunit_id = jobunit_id;
	}
	
	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
	public java.lang.String getJob_id() {
		return job_id;
	}

	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
	public void setJob_id(java.lang.String job_id) {
		this.job_id = job_id;
	}
	
	/**
	 * 転送ファシリティIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 転送ファシリティID
	 */
	public java.lang.String getSrc_facility_id() {
		return src_facility_id;
	}
	
	/**
	 * 転送ファシリティIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param src_facility_id 転送ファシリティID
	 */
	public void setSrc_facility_id(java.lang.String src_facility_id) {
		this.src_facility_id = src_facility_id;
	}
	
	/**
	 * 受信ファシリティIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 受信ファシリティID
	 */
	public java.lang.String getDest_facility_id() {
		return dest_facility_id;
	}
	
	/**
	 * 受信ファシリティIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param dest_facility_id 受信ファシリティID
	 */
	public void setDest_facility_id(java.lang.String dest_facility_id) {
		this.dest_facility_id = dest_facility_id;
	}
	
	/**
	 * スコープ処理方法を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return スコープ処理方法
	 * 
	 * @see com.clustercontrol.bean.ProcessingMethodConstant
	 */
	public java.lang.Integer getProcess_mode() {
		return process_mode;
	}
	
	/**
	 * スコープ処理方法を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param process_mode スコープ処理方法
	 * 
	 * @see com.clustercontrol.bean.ProcessingMethodConstant
	 */
	public void setProcess_mode(java.lang.Integer process_mode) {
		this.process_mode = process_mode;
	}
	
	/**
	 * ファイルを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return ファイル
	 */
	public java.lang.String getSrc_file() {
		return src_file;
	}
	
	/**
	 * ファイルを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param src_file ファイル
	 */
	public void setSrc_file(java.lang.String src_file) {
		this.src_file = src_file;
	}
	
	/**
	 * 転送作業ディレクトリを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 転送作業ディレクトリ
	 */
	public java.lang.String getSrc_work_dir() {
		return src_work_dir;
	}
	
	/**
	 * 転送作業ディレクトリを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param src_work_dir 転送作業ディレクトリ
	 */
	public void setSrc_work_dir(java.lang.String src_work_dir) {
		this.src_work_dir = src_work_dir;
	}
	
	/**
	 * 受信ディレクトリを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 受信ディレクトリ
	 */
	public  java.lang.String getDest_directory() {
		return dest_directory;
	}
	
	/**
	 * 受信ディレクトリを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param dest_directory 受信ディレクトリ
	 */
	public void setDest_directory(java.lang.String dest_directory) {
		this.dest_directory = dest_directory;
	}
	
	/**
	 * 受信作業ディレクトリを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 受信作業ディレクトリ
	 */
	public java.lang.String getDest_work_dir() {
		return dest_work_dir;
	}
	
	/**
	 * 受信作業ディレクトリを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param dest_work_dir 受信作業ディレクトリ
	 */
	public void setDest_work_dir(java.lang.String dest_work_dir) {
		this.dest_work_dir = dest_work_dir;
	}
	
	/**
	 * ファイル圧縮を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return ファイル圧縮
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getCompression_flg() {
		return compression_flg;
	}
	
	/**
	 * ファイル圧縮を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param compression_flg ファイル圧縮
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setCompression_flg(java.lang.Integer compression_flg) {
		this.compression_flg = compression_flg;
	}
	
	/**
	 * ファイルチェックを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return ファイルチェック
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getCheck_flg() {
		return check_flg;
	}
	
	/**
	 * ファイルチェックを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param check_flg ファイルチェック
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setCheck_flg(java.lang.Integer check_flg) {
		this.check_flg = check_flg;
	}
	
	/**
	 * 実効ユーザを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 実効ユーザ
	 */
	public java.lang.String getEffective_user() {
		return effective_user;
	}
	
	/**
	 * 実効ユーザを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param effective_user 実効ユーザ
	 */
	public void setEffective_user(java.lang.String effective_user) {
		this.effective_user = effective_user;
	}
	
	/**
	 * ジョブマスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブマスタ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterBean#ejbFindByPrimaryKey(JobMasterPK)
	 */
    public JobMasterLocal getJobMaster() {
		JobMasterLocal jobMaster = null;
		try {
			jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(getJobunit_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobMaster;
	}
}
