/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.jobmanagement.dao.JobRelationInfoDAOImpl;


/**
 * ジョブリレーション情報のBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="JobRelationInfo"
 *    jndi-name="JobRelationInfo"
 *    type="BMP"
 *    view-type="local"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Log BMP EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao
 *    class="com.clustercontrol.jobmanagement.dao.JobRelationInfoDAO"
 *    impl-class="com.clustercontrol.jobmanagement.dao.JobRelationInfoDAOImpl"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAO
 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAOImpl
 */
public abstract class JobRelationInfoBean implements javax.ejb.EntityBean {
	/** セッションID */
    protected String session_id;
	/** 所属ジョブユニットのジョブID */
	protected String jobunit_id;
	/** ジョブID */
    protected String job_id;
	/** 親ジョブが所属するジョブユニットのジョブID */
	protected String parent_jobunit_id;
    /** 親ジョブID */
    protected String parent_job_id;
    
    /**
     * ジョブリレーション情報を生成します。
     * 
     * @ejb.create-method 
     * 
     * @param session_id セッションID
     * @param jobunit_id 所属ジョブユニットのジョブID
     * @param job_id ジョブID
     * @param parent_jobunit_id 親ジョブが所属するジョブユニットのジョブID
     * @param parent_job_id 親ジョブID
     * @return プライマリーキー
     * @throws javax.ejb.CreateException
     */
    public JobRelationInfoPK ejbCreate(
            String session_id, 
            String jobunit_id, 
            String job_id, 
            String parent_jobunit_id, 
            String parent_job_id
            ) throws javax.ejb.CreateException {
        this.session_id = session_id;
        this.jobunit_id = jobunit_id;
        this.job_id = job_id;
        this.parent_jobunit_id = parent_jobunit_id;
        this.parent_job_id = parent_job_id;
        return null;
    }
    
	/**
	 * 全てのジョブリレーション情報を検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するジョブリレーション情報を検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAOImpl#findByPrimaryKey(JobRelationInfoPK)
	 */
	public JobRelationInfoPK ejbFindByPrimaryKey(JobRelationInfoPK pk) throws FinderException {
		return null;
	}
	
	/**
	 * セッションIDと親ジョブIDに一致するジョブリレーション情報を検索します。
	 * 
	 * @param session_id セッションID
	 * @param parent_job_id 親ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAOImpl#findByParentJobId(String, String)
	 */
	public Collection ejbFindByParentJobId(java.lang.String session_id, java.lang.String parent_job_id) throws FinderException {
		return null;
	}
	
	/**
	 * セッションID、親ジョブID、実行状態(待機orスキップor実行中)が一致するジョブリレーション情報を検索します。
	 * 
	 * @param session_id セッションID
	 * @param parent_job_id 親ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAOImpl#findByStartStatus(String, String)
	 */
	public Collection ejbFindByStartStatus(java.lang.String session_id, java.lang.String parent_job_id) throws FinderException {
		return null;
	}
	
	/**
	 * セッションID、親ジョブID、実行状態が一致するジョブリレーション情報を検索します。
	 * 
	 * @param session_id セッションID
	 * @param parent_job_id 親ジョブID
	 * @param status 実行状態
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAOImpl#findByStatus(String, String, Integer)
	 */
	public Collection ejbFindByStatus(java.lang.String session_id, java.lang.String parent_job_id, java.lang.Integer status) throws FinderException {
		return null;
	}
	
	/**
	 * セッションID、親ジョブIDが一致するジョブリレーション情報を検索します。<BR>
	 * 検索結果は、開始日時による昇順ソート
	 * 
	 * @param session_id セッションID
	 * @param parent_job_id 親ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAOImpl#findByStartDate(String, String)
	 */
	public Collection ejbFindByStartDate(java.lang.String session_id, java.lang.String parent_job_id) throws FinderException {
		return null;
	}
	
	/**
	 * セッションID、ジョブIDが一致するジョブリレーション情報を検索します。
	 * 
	 * @param session_id セッションID
	 * @param job_id ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAOImpl#findBySessionIdAndJobId(String, String)
	 */
	public JobRelationInfoPK ejbFindBySessionIdAndJobId(java.lang.String session_id, java.lang.String job_id) throws FinderException {
		return null;
	}

	/**
	 * セッションIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return セッションID
	 */
    public java.lang.String getSession_id() {
    	return session_id;
    }

	/**
	 * セッションIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param session_id セッションID
	 */
    public void setSession_id(java.lang.String session_id) {
    	this.session_id = session_id;
    }

	/**
	 * 所属ジョブユニットのジョブIDを返す。<BR>
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 所属ジョブユニットのジョブID
	 */
	public java.lang.String getJobunit_id() {
		return jobunit_id;
	}
	
	/**
	 * 所属ジョブユニットのジョブIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 */
	public void setJobunit_id(java.lang.String jobunit_id) {
		this.jobunit_id = jobunit_id;
	}
	
	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
    public java.lang.String getJob_id() {
    	return job_id;
    }

	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }

	/**
	 * 親ジョブが所属するジョブユニットのジョブIDを返す。<BR>
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 親ジョブが所属するジョブユニットのジョブID
	 */
	public java.lang.String getParent_jobunit_id() {
		return parent_jobunit_id;
	}
	
	/**
	 * 親ジョブが所属するジョブユニットのジョブIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param parent_jobunit_id 親ジョブが所属するジョブユニットのジョブID
	 */
	public void setParent_jobunit_id(java.lang.String parent_jobunit_id) {
		this.parent_jobunit_id = parent_jobunit_id;
	}
	
	/**
	 * 親ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
    public java.lang.String getParent_job_id() {
    	return parent_job_id;
    }

	/**
	 * 親ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param parent_job_id 親ジョブID
	 */
    public void setParent_job_id(java.lang.String parent_job_id) {
    	this.parent_job_id = parent_job_id;
    }
    
	/**
	 * セッションジョブを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return セッションジョブ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobBean#ejbFindByPrimaryKey(JobSessionJobPK)
	 */
    public JobSessionJobLocal getJobSessionJob() {
    	JobSessionJobLocal jobSessionJob = null;
		try {
			jobSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(getSession_id(), getJobunit_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobSessionJob;
	}
    
	/**
	 * 履歴情報を作成する。<BR>
	 * ジョブリレーション情報をジョブリレーションマスタから作成します。
	 * 
	 * @ejb.home-method view-type="both"
	 * 
	 * @param sessionId セッションID
	 * @param jobunitId 所属ジョブユニットのジョブID
	 * @param jobs ジョブIDのコレクション
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAOImpl#makeSession(String, String, Collection)
	 */
    public void ejbHomeMakeSession(String sessionId, String jobunitId, Collection jobs) throws javax.ejb.CreateException{
    	JobRelationInfoDAOImpl jriDAO = new JobRelationInfoDAOImpl(); 
    	
    	jriDAO.makeSession(sessionId, jobunitId, jobs);
    }

}