/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.util.ArrayList;
import java.util.Locale;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;

/**
 * ジョブ操作用プロパティを作成するクラスです。
 *
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobOperationProperty {
	//FIXME javadoc修正、操作用プロパティにjobunitIDが必要か確認。
	@SuppressWarnings("unchecked")
	public ArrayList<String> getAvailableStartOperation (String sessionId, String jobunitId, String jobId, String facilityId, Locale locale) {
		int status = 0;
	    int jobType = 0;
	    
	    try {
            if(facilityId != null && facilityId.length() > 0){
                //セッションIDとジョブIDから、セッションジョブを取得
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobunitId, jobId));
                
                //ジョブタイプを取得
                if(sessionJob.getJobInfo().getJob_type().intValue() == JobConstant.TYPE_FILEJOB){
                	jobId = jobId + "_" + facilityId;
                	facilityId = null;
                	
                	//セッションIDとジョブIDから、セッションジョブを取得
                    JobSessionJobLocal childSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobunitId, jobId));
	                
	                //実行状態を取得
	                status = childSessionJob.getStatus().intValue();
	                
	                //ジョブタイプを取得
	                jobType = JobOperationJudgment.TYPE_JOBNET;
                }
                else{
	                //セッションIDとジョブIDから、セッションジョブを取得
	                JobSessionNodeLocal sessionNode = 
	                    JobSessionNodeUtil.getLocalHome().findByPrimaryKey(
	                            new JobSessionNodePK(sessionId, jobunitId, jobId, facilityId));
	                
	                //実行状態を取得
	                status = sessionNode.getStatus().intValue();
	                
	                //ジョブタイプを取得
	                jobType = JobOperationJudgment.TYPE_NODE;
                }
            }
            else{
                //セッションIDとジョブIDから、セッションジョブを取得
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobunitId, jobId));
                
                //実行状態を取得
                status = sessionJob.getStatus().intValue();
                
                //ジョブタイプを取得
                if(sessionJob.getJobInfo().getJob_type().intValue() == JobConstant.TYPE_JOB){
                    jobType = JobOperationJudgment.TYPE_JOB;
                }
                else{
                    jobType = JobOperationJudgment.TYPE_JOBNET;
                }
            }
        } catch (Exception e) {
        	
        }
        
        ArrayList<String> values = new ArrayList<String>();
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_START_AT_ONCE, jobType, status)){
		    values.add(OperationConstant.STRING_START_AT_ONCE);
		}
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_START_SUSPEND, jobType, status)){
		    values.add(OperationConstant.STRING_START_SUSPEND);
		}
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_START_WAIT, jobType, status)){
		    values.add(OperationConstant.STRING_START_WAIT);
		}
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_START_SKIP, jobType, status)){
		    values.add(OperationConstant.STRING_START_SKIP);
		}
		
		return values;
	}
	
	public ArrayList<String> getAvailableStopOperation(String sessionId, String jobunitId, String jobId, String facilityId, Locale locale) {
		int status = 0;
	    int jobType = 0;
	    
	    try {
            if(facilityId != null && facilityId.length() > 0){
                //セッションIDとジョブIDから、セッションジョブを取得
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobunitId, jobId));
                
                //ジョブタイプを取得
                if(sessionJob.getJobInfo().getJob_type().intValue() == JobConstant.TYPE_FILEJOB){
                	jobId = jobId + "_" + facilityId;
                	facilityId = null;
                	
                	//セッションIDとジョブIDから、セッションジョブを取得
                    JobSessionJobLocal childSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobunitId, jobId));
	                
	                //実行状態を取得
	                status = childSessionJob.getStatus().intValue();
	                
	                //ジョブタイプを取得
	                jobType = JobOperationJudgment.TYPE_JOBNET;
                }
                else{
	                //セッションIDとジョブIDから、セッションジョブを取得
	                JobSessionNodeLocal sessionNode = 
	                    JobSessionNodeUtil.getLocalHome().findByPrimaryKey(
	                            new JobSessionNodePK(sessionId, jobunitId, jobId, facilityId));
	                
	                //実行状態を取得
	                status = sessionNode.getStatus().intValue();
	                
	                //ジョブタイプを取得
	                jobType = JobOperationJudgment.TYPE_NODE;
                }
            }
            else{
                //セッションIDとジョブIDから、セッションジョブを取得
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobunitId, jobId));
                
                //実行状態を取得
                status = sessionJob.getStatus().intValue();
                
                //ジョブタイプを取得
                if(sessionJob.getJobInfo().getJob_type().intValue() == JobConstant.TYPE_JOB){
                    jobType = JobOperationJudgment.TYPE_JOB;
                }
                else{
                    jobType = JobOperationJudgment.TYPE_JOBNET;
                }
            }
        } catch (Exception e) {
        }
        
        ArrayList<String> values = new ArrayList<String>();
        if(JobOperationJudgment.judgment(OperationConstant.TYPE_STOP_AT_ONCE, jobType, status)){
		    values.add(OperationConstant.STRING_STOP_AT_ONCE);
		}
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_STOP_SUSPEND, jobType, status)){
		    values.add(OperationConstant.STRING_STOP_SUSPEND);
		}
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_STOP_WAIT, jobType, status)){
		    values.add(OperationConstant.STRING_STOP_WAIT);
		}
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_STOP_SKIP, jobType, status)){
		    values.add(OperationConstant.STRING_STOP_SKIP);
		}
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_STOP_MAINTENANCE, jobType, status)){
			values.add(OperationConstant.STRING_STOP_MAINTENANCE);
		}
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_STOP_FORCE, jobType, status)){
		    values.add(OperationConstant.STRING_STOP_FORCE);
		}
		
		return values;
	}
	
}
