/*
 
 Copyright (C) 2010 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.util;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.JobMasterNotFoundException;
import com.clustercontrol.jobmanagement.ejb.entity.JobUserRelationMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobUserRelationMasterUtil;


/**
 * 
 * 
 *
 */public class ManagementUserUtil {
	
	/** ログ出力のインスタンス */
	protected static Log m_log = LogFactory.getLog( ManagementUserUtil.class );	
	
	/**
	 * 
	 * 引数で指定されたジョブユニットをユーザが参照可能かチェックします。<BR>
	 * 
	 * @param jobunitId ジョブユニットのジョブID
	 * @param userId ユーザID
	 * @return 引数で指定されたジョブユニットをユーザが参照可能な場合true
	 * @throws NamingException
	 * @throws JobMasterNotFoundException 
	 */
	public static boolean isReferable(String jobunitId, String userId) throws NamingException, JobMasterNotFoundException {
		m_log.debug("referable check : jobunitId" + jobunitId + ", userId=" + userId);
		boolean ret = false;
		
		//登録するジョブユニットのジョブIDから、管理ユーザ一覧を取得
		Collection<JobUserRelationMasterLocal> relations = null;
		try {
			relations = JobUserRelationMasterUtil
					.getLocalHome().findByJobunitId(jobunitId);
		} catch (FinderException e) {
			m_log.warn("" + e.getMessage());
			JobMasterNotFoundException je = new JobMasterNotFoundException(e.getMessage(), e);
			je.setJobunitId(jobunitId);
			throw je;
		}
		
		//ジョブユーザリレーションが存在しなければ処理する
		if (relations == null || relations.size() == 0) {
			//register
			ret = true;
			
		//ジョブユーザリレーションが存在する場合は、ログインユーザが管理ユーザに設定されているか確認する
		} else {
			for (JobUserRelationMasterLocal relation : relations){
				//ジョブユーザリレーションが存在し、ログインユーザがマッチすれば削除->登録する
				if (userId.equals(relation.getUser_id())) {
					ret = true;
				}
			}
		}
		
		m_log.debug("referable check result : jobunitId" + jobunitId + ", userId=" + userId + ", result=" + ret);
		return ret;
	}

}
