/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.factory;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.NotifyNotFoundException;
import com.clustercontrol.maintenance.bean.MaintenanceKeepMstConstant;

public abstract class MaintenanceObject {
	protected static Log m_log = LogFactory.getLog( MaintenanceObject.class );
	/** 
	 * RMIAdaptorのルックアップ名。<BR>
	 * イベント情報のキャッシュをフラッシュするために使用します。
	 */
	public static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	/**
	 * 操作名。<BR>
	 * キャッシュをフラッシュする操作名を指定します。
	 */
	public static final String OPERATION_NAME = "flushCache";

	/** キャッシュリフレッシュ対象のEntity */
	public String[] OBJECT_NAME;
	
	/**
	 * コンストラクタ
	 * @param OBJECT_NAME
	 */
	public MaintenanceObject(String[] OBJECT_NAME) {
		this.OBJECT_NAME = OBJECT_NAME;
	}
	
	/**
	 * 汎用削除処理
	 * @param keep_id
	 * @param status
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 * @throws CreateException
	 * @throws SQLException
	 * @throws HinemosUnknownException 
	 * @throws NotifyNotFoundException 
	 */
	public int delete(String keep_id, boolean status) throws FinderException, NamingException, CreateException, SQLException, RemoveException, HinemosUnknownException, NotifyNotFoundException{;
		int ret;
		m_log.debug("delete() : keep_id : " + keep_id + ", status : " + status);
		Timestamp timestamp = getTimestamp(keep_id);
		
		ret = _delete(timestamp, status);
		
		cacheReflesh(OBJECT_NAME);
		return ret;
	};

	/**
	 * 削除処理実態
	 * @param keep
	 * @param status
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 * @throws CreateException
	 * @throws SQLException
	 * @throws NotifyNotFoundException 
	 */
	abstract public int _delete(Timestamp keep, boolean status) throws FinderException, NamingException, CreateException, SQLException, RemoveException, HinemosUnknownException, NotifyNotFoundException;

	/**
	 * 保存期限ID(keep_id)に対する保存期間初日のtimestamp値を返却する
	 * @param keep_id
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 * @throws CreateException
	 * @throws HinemosUnknownException 
	 */
	private Timestamp getTimestamp(String keep_id) throws FinderException, NamingException, CreateException {
		m_log.debug("getTimestamp() keep_id : " + keep_id);

		// 現在時刻のカレンダを取得
		Calendar calendar = Calendar.getInstance();
		
		// 期間指定がある場合
		if(MaintenanceKeepMstConstant.NON.equals(keep_id)){
			return new Timestamp(calendar.getTimeInMillis());
		} else if(MaintenanceKeepMstConstant.ONE_WEEK.equals(keep_id)){
			calendar.add(Calendar.WEEK_OF_MONTH, -1);
		} else if (MaintenanceKeepMstConstant.TWO_WEEKS.equals(keep_id)){
			calendar.add(Calendar.WEEK_OF_MONTH, -2);
		} else if (MaintenanceKeepMstConstant.ONE_MONTH.equals(keep_id)){
			calendar.add(Calendar.MONTH, -1);
		} else if (MaintenanceKeepMstConstant.TWO_MONTHS.equals(keep_id)){
			calendar.add(Calendar.MONTH, -2);
		} else if (MaintenanceKeepMstConstant.THREE_MONTHS.equals(keep_id)){
			calendar.add(Calendar.MONTH, -3);
		} else if (MaintenanceKeepMstConstant.SIX_MONTHS.equals(keep_id)){
			calendar.add(Calendar.MONTH, -6);
		} else if (MaintenanceKeepMstConstant.ONE_YEAR.equals(keep_id)){
			calendar.add(Calendar.YEAR, -1);
		} else {
			m_log.error("getTimestamp() : keep_id doesn't exists, keep_id = [" + keep_id + "]");
		}
		
		return new Timestamp(calendar.getTimeInMillis());
	}

	/**
	 * 指定したEntity Cacheをフラッシュする
	 * @param objectName
	 */
	public void cacheReflesh(String[] objectName){
		m_log.debug("cacheReflesh() objectName[] size : " + objectName.length);

		//Flush Entity Cache
		try{
	        InitialContext ic = new InitialContext();
	        
	        //RMIAdaptorを取得
	        RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

	        for (int i = 0; i < objectName.length; i++) {
	    		m_log.debug("cacheReflesh() objectName : " + objectName[i]);
		        //ObjectNameを設定
		        ObjectName name = new ObjectName(objectName[i]);
		        
		        //ObjectNameのOperationNameのメソッドを実行
		        server.invoke(name, OPERATION_NAME, null, null);				
			}

		} catch (Exception e) {
			m_log.warn("cacheReflesh() Unknown Error ", e);
		} 
	}
}
