/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoUtil;

/**
 * 数値監視の判定情報を変更する抽象クラス<BR>
 * <p>
 * 数値監視を行う各監視管理クラスで継承してください。
 *
 * @version 3.0.0
 * @since 2.0.0
 */
abstract public class ModifyMonitorNumericValueType extends ModifyMonitor{
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( ModifyMonitorNumericValueType.class );
	
	/**
	 * 監視情報より数値監視の判定情報を取得し、変更します。
	 * <p>
	 * <ol>
	 * <li>監視情報より判定情報を削除します。</li>
	 * <li>判定情報を作成し、監視情報に設定します。</li>
	 * </ol>
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoBean
	 */
	@Override
	@SuppressWarnings("unchecked")
	public boolean modifyJudgementInfo() throws CreateException, RemoveException, NamingException {
		
		// 数値監視判定情報を削除
		Collection ct = m_monitor.getMonitorNumericValueInfo();
	    if(ct != null && ct.size() > 0){
	        Object[] infoArray = ct.toArray();
	        for(int j = 0; j < infoArray.length; j++){
	        	MonitorNumericValueInfoLocal info = (MonitorNumericValueInfoLocal)infoArray[j];
	            if(info != null){
	            	info.remove();
	            }
	        }
	    }
		
		// 数値監視判定情報を設定
		ArrayList<MonitorNumericValueInfo> valueList = m_monitorInfo.getNumericValueInfo();
		ArrayList<MonitorNumericValueInfoLocal> valueLocalList = new ArrayList<MonitorNumericValueInfoLocal>();
		
		for(MonitorNumericValueInfo value : valueList){
			if(value != null){
				MonitorNumericValueInfoLocal local = MonitorNumericValueInfoUtil.getLocalHome().create(
						m_monitorInfo.getMonitorTypeId(),
						m_monitorInfo.getMonitorId(),
						value.getPriority(),
						value.getThresholdUpperLimit(),
						value.getThresholdLowerLimit(),
						value.getMessageId(),
						value.getMessage());
				valueLocalList.add(local);
			}
		}
		return true;
	}
}
