/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorTruthValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorTruthValueInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorTruthValueInfoUtil;

/**
 * 真偽値監視の判定情報を変更する抽象クラス<BR>
 * <p>
 * 真偽値監視を行う各監視管理クラスで継承してください。
 *
 * @version 3.0.0
 * @since 2.0.0
 */
abstract public class ModifyMonitorTruthValueType extends ModifyMonitor{
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( ModifyMonitorTruthValueType.class );
	
	/**
	 * 監視情報より真偽値監視の判定情報を取得し、変更します。
	 * <p>
	 * <ol>
	 * <li>監視情報より判定情報を削除します。</li>
	 * <li>判定情報を作成し、監視情報に設定します。</li>
	 * </ol>
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorTruthValueInfoBean
	 */
	@Override
	@SuppressWarnings("unchecked")
	public boolean modifyJudgementInfo() throws CreateException, RemoveException, NamingException {
		
		// 真偽値監視判定情報を削除
		Collection ct = m_monitor.getMonitorTruthValueInfo();
	    if(ct != null && ct.size() > 0){
	        Object[] infoArray = ct.toArray();
	        for(int j = 0; j < infoArray.length; j++){
	        	MonitorTruthValueInfoLocal info = (MonitorTruthValueInfoLocal)infoArray[j];
	            if(info != null){
	            	info.remove();
	            }
	        }
	    }		
		
		// 真偽値監視判定情報を設定
		ArrayList valueList = m_monitorInfo.getTruthValueInfo();
		ArrayList<MonitorTruthValueInfoLocal> valueLocalList = new ArrayList<MonitorTruthValueInfoLocal>();
		
		MonitorTruthValueInfo value = null;
		for(int index=0; index<valueList.size(); index++){
			value = (MonitorTruthValueInfo)valueList.get(index);
			if(value != null){
				MonitorTruthValueInfoLocal local = MonitorTruthValueInfoUtil.getLocalHome().create(
						m_monitorInfo.getMonitorTypeId(),
						m_monitorInfo.getMonitorId(),
						value.getPriority(),
						value.getTruthValue(),
						value.getMessageId(),
						value.getMessage());
				valueLocalList.add(local);
			}
		}
		
		return true;
	}
}
