/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Collection;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.notify.bean.NotifyTypeConstant;

/**
 * 通知情報のCMP Entity Beanです。
 * 
 * @ejb.bean name="NotifyInfo"
 *     jndi-name="NotifyInfo"
 *     type="CMP"
 *     view-type = "local"
 *     primkey-field="notifyId"
 *     schema="NotifyInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *         
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 *    
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_notify_info"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 *           
 * @ejb.persistence 
 *     table-name="cc_notify_info"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM NotifyInfo as a"  
 *     signature="java.util.Collection findAll()"
 *     
 * @ejb.finder
 *    query=""
 *    signature="java.util.Collection findAllOrderByNotifyId()"
 * 
 * @ejb.finder
 *   signature="java.util.Collection findByUseType(java.lang.String keyWord)"
 *   query="SELECT OBJECT(a) FROM NotifyInfo as a WHERE a.notifyId like ?1"
 * 
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM NotifyInfo as a ORDER BY a.notifyId"
 *    signature="java.util.Collection findAllOrderByNotifyId()"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.pk class="java.lang.String"
 */
public abstract class NotifyInfoBean implements EntityBean, NotifyDetail {
	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog( NotifyInfoBean.class );
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
	}
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知情報を生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param notifyId 通知ID
	 * @param description 説明
	 * @param notifyType 通知タイプ
	 * @param initialCount 初回通知するまでのカウント
	 * @param renotifyType 再通知種別
	 * @param renotifyPeriod 再通知抑制期間（分）
	 * @param regDate 作成日時
	 * @param updateDate 最終変更日時
	 * @param regUser 作成ユーザ
	 * @param updateUser 更新ユーザ
	 * @param vaildFlg 有効フラグ
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	public java.lang.String ejbCreate(
			String notifyId,
			String description,
			Integer notifyType,
			Integer initialCount,
			Integer renotifyType,
			Integer renotifyPeriod,
			Timestamp regDate,
			Timestamp updateDate,
			String regUser,
			String updateUser,
			Integer vaildFlg
//			String useType	FIXME	 * @param useType 使用種別
			) throws javax.ejb.CreateException {
		
		
		setNotifyId(notifyId);
		setDescription(description);
		setNotifyType(notifyType);
		setInitialCount(initialCount);
		setRenotifyType(renotifyType);
		setRenotifyPeriod(renotifyPeriod);
		setRegDate(regDate);
		setUpdateDate(updateDate);
		setRegUser(regUser);
		setUpdateUser(updateUser);
		setValidFlg(vaildFlg);
//		setUseType(useType);
		
		return null;
	}
	


	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
	}
	
	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract String getNotifyId();
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyId 通知ID
	 */
	public abstract void setNotifyId(String notifyId);
	
	/**
	 * 説明を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return 説明
	 */
	public abstract String getDescription();
	
	/**
	 * 説明を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param description 説明
	 */
	public abstract void setDescription(String description);
	
    /**
     * 通知タイプを返します。
     *
     * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_type"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *
	 * @ejb.interface-method 
	 * 
     * @return notifyType 通知タイプ
     *
     * @see com.clustercontrol.bean.ValidConstant
     */
	public abstract Integer getNotifyType();
	
	
	/**
	 * 通知タイプを設定します。
	 *
	 * @ejb.interface-method
	 * 
	 * @param notifyType
	 */
	public abstract void setNotifyType(Integer notifyType);
	
	
	/**
	 * 初回通知するまでのカウント（この数以上同じ重要度の監視結果が連続した場合に始めて通知）を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="initial_count"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return 初回通知するまでのカウント
	 */
	public abstract Integer getInitialCount();
	
	/**
	 * 初回通知するまでのカウント（この数以上同じ重要度の監視結果が連続した場合に始めて通知）を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param initialCount 初回通知するまでのカウント
	 */
	public abstract void setInitialCount(Integer initialCount);
	
	/**
	 * 再通知種別を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="renotify_type"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return 再通知種別
	 */
	public abstract Integer getRenotifyType();
	
	/**
	 * 再通知種別を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param renotifyType 再通知種別
	 */
	public abstract void setRenotifyType(Integer renotifyType);
	
	/**
	 * 再通知抑制期間を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="renotify_period"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return 再通知抑制期間（分）
	 */
	public abstract Integer getRenotifyPeriod();
	
	/**
	 * 再通知抑制期間を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param renotifyPeriod 再通知抑制期間（分）
	 */
	public abstract void setRenotifyPeriod(Integer renotifyPeriod);
	
	/**
	 * 作成日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return 作成日時
	 */
	public abstract Timestamp getRegDate();
	
	/**
	 * 作成日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param regDate 作成日時
	 */
	public abstract void setRegDate(Timestamp regDate);
	
	
	/**
	 * 最終変更日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return 最終変更日時
	 */
	public abstract Timestamp getUpdateDate();
	
	/**
	 * 最終変更日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param updateDate 最終変更日時
	 */
	public abstract void setUpdateDate(Timestamp updateDate);
	
	
	/**
	 *更新ユーザを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return updateUser 更新ユーザ
	 */
	public abstract String getUpdateUser();
	
	/**
	 * 最終変更ユーザを設定します。
	 * 
	 * @ejb.interface-method 
	 * @param updateUser 更新ユーザ
	 */
	public abstract void setUpdateUser(String updateUser);
	
	
     /**
	 *作成ユーザを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return updateUser 作成ユーザ
	 */
	public abstract String getRegUser();

	/**
	 * 作成ユーザを設定します。
	 * 
	 * @ejb.interface-method 
	 * @param regUser 作成ユーザ
	 */
	public abstract void setRegUser(String regUser);

	
	/**
	 * 有効無効フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="valid_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return vaildFlg 有効無効フラグ
	 */
	public abstract Integer getValidFlg();

	/**
     * 有効無効フラグを設定します。
     * 
     * @ejb.interface-method 
	 * @param vaildFlg 有効無効フラグ
	 */
	public abstract void setValidFlg(Integer validFlg);
	
	/**
	 * このCMPのデータをフィールドとして持つDataオブジェクト（NotifyInfoData）を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns Dataオブジェクト（NotifyInfoData）
	 */
	public abstract NotifyInfoData getData();
	
	/**
	 * 重要度毎の設定を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns 重要度毎の設定
	 */
	public NotifyDetail getNotifyDetail(int priority){
		m_log.debug("getNotifyDetail() " + getNotifyId() + ",  priority = " + priority);
		
		switch (getNotifyType()) {
		case NotifyTypeConstant.TYPE_EVENT:
			Collection<NotifyEventInfoLocal> events = getNotifyEventInfo();
			for(NotifyEventInfoLocal event : events){
				if(event.getPriority().intValue() == priority){
					m_log.debug(getNotifyId() + ", notify type = " + getNotifyType());
					return event;
				}
			}
			m_log.error("incorrect data. size = " + events.size() + "  " + getNotifyId() + "  type = " + getNotifyType());
			break;
		case NotifyTypeConstant.TYPE_STATUS:
			Collection<NotifyStatusInfoLocal> statuses = getNotifyStatusInfo();
			for(NotifyStatusInfoLocal status : statuses){
				if(status.getPriority().intValue() == priority){
					m_log.debug(getNotifyId() + ", notify type = " + getNotifyType());
					return status;
				}
			}
			m_log.error("incorrect data. size = " + statuses.size() + "  " + getNotifyId() + "  type = " + getNotifyType());
			break;
		case NotifyTypeConstant.TYPE_MAIL:
			Collection<NotifyMailInfoLocal> mails = getNotifyMailInfo();
			for(NotifyMailInfoLocal mail : mails){
				if(mail.getPriority().intValue() == priority){
					m_log.debug(getNotifyId() + ", notify type = " + getNotifyType());
					return mail;
				}
			}
			m_log.error("incorrect data. size = " + mails.size() + "  " + getNotifyId() + "  type = " + getNotifyType());
			break;
		case NotifyTypeConstant.TYPE_JOB:
			Collection<NotifyJobInfoLocal> jobs = getNotifyJobInfo();
			for(NotifyJobInfoLocal job : jobs){
				if(job.getPriority().intValue() == priority){
					m_log.debug(getNotifyId() + ", notify type = " + getNotifyType());
					return job;
				}
			}
			m_log.error("incorrect data. size = " + jobs.size() + "  " + getNotifyId() + "  type = " + getNotifyType());
			break;
		case NotifyTypeConstant.TYPE_LOG_ESCALATE:
			Collection<NotifyLogEscalateInfoLocal> logs = getNotifyLogEscalateInfo();
			for(NotifyLogEscalateInfoLocal log : logs){
				if(log.getPriority().intValue() == priority){
					m_log.debug(getNotifyId() + ", notify type = " + getNotifyType());
					return log;
				}
			}
			m_log.error("incorrect data. size = " + logs.size() + "  " + getNotifyId() + "  type = " + getNotifyType());
			break;
		case NotifyTypeConstant.TYPE_COMMAND:
			Collection<NotifyCommandInfoLocal> commands = getNotifyCommandInfo();
			for(NotifyCommandInfoLocal command : commands){
				if(command.getPriority().intValue() == priority){
					m_log.debug(getNotifyId() + ", notify type = " + getNotifyType());
					return command;
				}
			}
			m_log.error("incorrect data. size = " + commands.size() + "  " + getNotifyId() + "  type = " + getNotifyType());
			break;
		default:
			m_log.error("notify type mismatch. " + getNotifyId() + "  type = " + getNotifyType());
			return null;
		}
		m_log.error("incorrect data. " + getNotifyId() + "  type = " + getNotifyType());
		return null;
	}

// FIXME
//	/**
//	 * 使用種別を返します。
//	 * 
//	 * @ejb.persistent-field 
//	 * @ejb.persistence
//	 *    column-name="use_type"
//	 *     jdbc-type="VARCHAR"
//	 *     sql-type="VARCHAR(64)"
//	 *     read-only="false"
//	 *  
//	 * @ejb.interface-method
//	 * 
//	 * @return useType 使用種別
//	 */
//	public abstract String getUseType();
//
//	/**
//     * 使用種別を設定します。
//     * 
//     * @ejb.interface-method 
//	 * @param useType 使用種別
//	 */
//	public abstract void setUseType(String useType);
	
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * 通知イベント情報を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 *    name="NotifyInfo-NotifyEventInfo"
	 *    role-name="NotifyInfo-NotifyEventInfo(single)"
	 *    target-cascade-delete="true"
	 * 
	 * @return 通知イベント情報のコレクション
	 */
	public abstract Collection<NotifyEventInfoLocal> getNotifyEventInfo();
	
	/**
	 * 通知イベント情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 通知イベント情報のコレクション
	 */
	public abstract void setNotifyEventInfo(Collection<NotifyEventInfoLocal> collection);
	
	/**
	 * 通知ステータス情報を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 *    name="NotifyInfo-NotifyStatusInfo"
	 *    role-name="NotifyInfo-NotifyStatusInfo(single)"
	 *    target-cascade-delete="true"
	 * 
	 * return 通知ジョブ情報のコレクション
	 * 
	 */
	public abstract Collection<NotifyStatusInfoLocal> getNotifyStatusInfo();
	
	/**
	 * 通知ステータス情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 通知ステータス情報のコレクション
	 */
	public abstract void setNotifyStatusInfo(Collection<NotifyStatusInfoLocal> collection);
	
	
	/**
	 * 通知メール情報を返します。
	 *
	 * @ejb.interface-method view-type="local"
	 *  
	 * @ejb.relation 
	 *    name="NotifyInfo-NotifyMailInfo"
	 *    role-name="NotifyInfo-NotifyMailInfo(single)"
	 *    target-cascade-delete="true"
	 * 
	 */
	public abstract Collection<NotifyMailInfoLocal> getNotifyMailInfo();
	
	/**
	 * 通知メール情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 通知メール情報のコレクション
	 */
	public abstract void setNotifyMailInfo(Collection<NotifyMailInfoLocal> collection);
	
	/**
	 * 通知ジョブ情報を返します。
	 *
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 *    name="NotifyInfo-NotifyJobInfo"
	 *    role-name="NotifyInfo-NotifyJobInfo(single)"
	 *    target-cascade-delete="true"
	 * 
	 * retrun 通知ジョブ情報のコレクション
	 */
	public abstract Collection<NotifyJobInfoLocal> getNotifyJobInfo();
	
	/**
	 * 通知ジョブ情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 通知ジョブ情報のコレクション
	 */
	public abstract void setNotifyJobInfo(Collection<NotifyJobInfoLocal> collection);
	
	
	/**
	 * 通知ログエスカレーション情報を返します。
	 *
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation
	 *    name="NotifyInfo-NotifyLogEscalateInfo"
	 *    role-name="NotifyInfo-NotifyLogEscalateInfo(single)"
	 *    target-cascade-delete="true"
	 * 
	 * retrun 通知ログエスカレーション情報のコレクション
	 */
	public abstract Collection<NotifyLogEscalateInfoLocal> getNotifyLogEscalateInfo();
	
	/**
	 * 通知ログエスカレーション情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 通知ログエスカレーション情報のコレクション
	 */
	public abstract void setNotifyLogEscalateInfo(Collection<NotifyLogEscalateInfoLocal> collection);
	
	/**
	 * 通知コマンド情報を返します。
	 *
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation
	 *    name="NotifyInfo-NotifyCommandInfo"
	 *    role-name="NotifyInfo-NotifyCommandInfo(single)"
	 *    target-cascade-delete="true"
	 *
	 * retrun 通知ログエスカレーション情報のコレクション
	 */
	public abstract Collection<NotifyCommandInfoLocal> getNotifyCommandInfo();
	
	/**
	 * 通知コマンド情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 通知コマンド情報のコレクション
	 */
	public abstract void setNotifyCommandInfo(Collection<NotifyCommandInfoLocal> collection);

	/**
	 * 該当のエンティティに関連している通知履歴を取得します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 *    name="NotifyInfo-NotifyHistory"
	 *    role-name="NotifyInfo-NotifyHistory(single)"
	 *    target-cascade-delete="true"
	 * 
	 * @return 通知履歴のコレクション
	 */
	public abstract Collection<NotifyHistoryLocal> getNotifyHistory();
	
	/**
	 * 通該当のエンティティに関連している通知履歴を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 通知履歴のコレクション
	 */
	public abstract void setNotifyHistory(Collection<NotifyHistoryLocal> collection);
	
	/**
	 * 該当のエンティティに関連している通知関連情報を取得します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation
	 *    name="NotifyInfo-NotifyRelationInfo"
	 *    role-name="NotifyInfo-NotifyRelationInfo(single)"
	 *    target-cascade-delete="true"
	 * 
	 * @return 通知関連情報のコレクション
	 */
	public abstract Collection<NotifyRelationInfoLocal> getNotifyRelationInfo();
	
	/**
	 * 通該当のエンティティに関連している通知履歴を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 通知関連情報のコレクション
	 */
	public abstract void setNotifyRelationInfo(Collection<NotifyRelationInfoLocal> collection);
	
}
