/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.util;

import java.text.SimpleDateFormat;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.OutputBasicInfo;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.commons.util.HinemosProperties;
import com.clustercontrol.notify.bean.NotifySubstitutionParameterConstant;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;

/**
 * 文字列置換を行うユーティリティクラス
 *
 * @version 3.0.0
 * @since 3.0.0
 */
public class TextReplacer {
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( TextReplacer.class );
	
	/** 日時フォーマット。 */
	private static String SUBJECT_DATE_FORMAT ;

	/** 日時フォーマットデフォルト。 */
	private static String SUBJECT_DATE_FORMAT_DEFAULT = "yyyy/MM/dd HH:mm:ss" ;

	/** 日時フォーマット変換用 */
	private static SimpleDateFormat sdf ;
	
	static {
		SUBJECT_DATE_FORMAT = HinemosProperties.getProperty("common.notify.date.format", SUBJECT_DATE_FORMAT_DEFAULT);
		if(m_log.isDebugEnabled()){
			m_log.debug("TextReplacer.static SUBJECT_DATE_FORMAT = " + SUBJECT_DATE_FORMAT);
		}
		
		// set dateFormat
		sdf = new SimpleDateFormat(SUBJECT_DATE_FORMAT);
	}
	
	/**
	 * バックエンドのデータソースにアクセスせずに置換できるもののみを対象として、
	 * 引数で指定された文字列内の変数を置換します。
	 * 
	 * @param text 変換対象となるtext
	 * @param info 出力内容
	 * @return 変換後のtext
	 */
	public static synchronized String staticSubstitution(String text, OutputBasicInfo info) {

		// 入力のnullチェック
		if(text == null)
			return null;
		
		// 結果格納用
		String retText = text;
		if(m_log.isDebugEnabled()){
			m_log.debug("TextReplacer.staticSubstitution() : input text = " + retText);
		}
		
		// APPLICATION
		if(info.getApplication() != null){
			retText = retText.replace(NotifySubstitutionParameterConstant.APPLICATION, info.getApplication());
			if(m_log.isDebugEnabled()){
				m_log.debug("TextReplacer.staticSubstitution() : replase APPLICATION text = " + retText);
			}
		}
		
		// FACILITY_ID
		if(info.getFacilityId() != null){
			retText = retText.replace(NotifySubstitutionParameterConstant.FACILITY_ID, info.getFacilityId());
			if(m_log.isDebugEnabled()){
				m_log.debug("TextReplacer.staticSubstitution() : replase FACILITY_ID text = " + retText);
			}
		}
		
		// MONITOR_ID
		if(info.getMonitorId() != null){
			retText = retText.replace(NotifySubstitutionParameterConstant.MONITOR_ID, info.getMonitorId());
			if(m_log.isDebugEnabled()){
				m_log.debug("TextReplacer.staticSubstitution() : replase MONITOR_ID text = " + retText);
			}
		}
		
		// GENERATION_DATE
		if(info.getGenerationDate() != null){
			retText = retText.replace(NotifySubstitutionParameterConstant.GENERATION_DATE, sdf.format(info.getGenerationDate()));
			if(m_log.isDebugEnabled()){
				m_log.debug("TextReplacer.staticSubstitution() : replase GENERATION_DATE text = " + retText);
			}
		}
		
		// PLUGIN_ID
		if(info.getPluginId() != null){
			retText = retText.replace(NotifySubstitutionParameterConstant.PLUGIN_ID, info.getPluginId());
			if(m_log.isDebugEnabled()){
				m_log.debug("TextReplacer.staticSubstitution() : replase PLUGIN_ID text = " + retText);
			}
		}
		
		// PRIORITY
		if(PriorityConstant.typeToString(info.getPriority()) != null 
				&& !PriorityConstant.typeToString(info.getPriority()).equals("")){
			retText = retText.replace(NotifySubstitutionParameterConstant.PRIORITY, PriorityConstant.typeToString(info.getPriority()));
			if(m_log.isDebugEnabled()){
				m_log.debug("TextReplacer.staticSubstitution() : replase PRIORITY text = " + retText);
			}
		}
		
		// PRIORITY_JP
		if(PriorityConstant.typeToStringJP(info.getPriority()) != null 
				&& !PriorityConstant.typeToStringJP(info.getPriority()).equals("")){
			retText = retText.replace(NotifySubstitutionParameterConstant.PRIORITY_JP, PriorityConstant.typeToStringJP(info.getPriority()));
			if(m_log.isDebugEnabled()){
				m_log.debug("TextReplacer.staticSubstitution() : replase PRIORITY_JP text = " + retText);
			}
		}
		
		// PRIORITY_EN
		if(PriorityConstant.typeToStringEN(info.getPriority()) != null 
				&& !PriorityConstant.typeToStringEN(info.getPriority()).equals("")){
			retText = retText.replace(NotifySubstitutionParameterConstant.PRIORITY_EN, PriorityConstant.typeToStringEN(info.getPriority()));
			if(m_log.isDebugEnabled()){
				m_log.debug("TextReplacer.staticSubstitution() : replase PRIORITY_EN text = " + retText);
			}
		}
		
		// PRIORITY_NUM
		if(String.valueOf(info.getPriority()) != null 
				&& !String.valueOf(info.getPriority()).equals("")){
			retText = retText.replace(NotifySubstitutionParameterConstant.PRIORITY_NUM, String.valueOf(info.getPriority()));
			if(m_log.isDebugEnabled()){
				m_log.debug("TextReplacer.staticSubstitution() : replase PRIORITY_NUM text = " + retText);
			}
		}
		
		// SCOPE
		if(info.getScopeText() != null){
			retText = retText.replace(NotifySubstitutionParameterConstant.SCOPE, info.getScopeText());
			if(m_log.isDebugEnabled()){
				m_log.debug("TextReplacer.staticSubstitution() : replase SCOPE text = " + retText);
			}
		}
		
		// MESSAGE_ID
		if(info.getMessageId() != null){
			retText = retText.replace(NotifySubstitutionParameterConstant.MESSAGE_ID, info.getMessageId());
			if(m_log.isDebugEnabled()){
				m_log.debug("TextReplacer.staticSubstitution() : replase MESSAGE_ID text = " + retText);
			}
		}
		
		// MESSAGE
		if(info.getMessage() != null){
			retText = retText.replace(NotifySubstitutionParameterConstant.MESSAGE, info.getMessage());
			if(m_log.isDebugEnabled()){
				m_log.debug("TextReplacer.staticSubstitution() : replase MESSAGE text = " + retText);
			}
		}
		
		// ORG_MESSAGE
		if(info.getMessageOrg() != null){
			retText = retText.replace(NotifySubstitutionParameterConstant.ORG_MESSAGE, info.getMessageOrg());
			if(m_log.isDebugEnabled()){
				m_log.debug("TextReplacer.staticSubstitution() : replase ORG_MESSAGE text = " + retText);
			}
		}
		
		if(m_log.isDebugEnabled()){
			m_log.debug("TextReplacer.staticSubstitution() : output text = " + retText);
		}
		return retText;
	}

	
	/**
	 * 引数で指定された文字列内の変数を置換します。
	 * 
	 * @param text 変換対象となるtext
	 * @param info 出力内容
	 * @return 変換後のtext
	 * @throws NamingException 
	 * @throws FinderException 
	 */
	public static synchronized String substitution(String text, OutputBasicInfo info) throws NamingException, FinderException {
		// 結果格納用
		String retText;
		
		if(m_log.isDebugEnabled()){
			m_log.debug("TextReplacer.substitution() : text = " + text);
		}
		// バックエンドのデータソースにアクセスせずに置換できるものを置換
		retText = staticSubstitution(text, info);
		if(m_log.isDebugEnabled()){
			m_log.debug("TextReplacer.substitution() : staticSubstitution text = " + retText);
		}
		
		// IPアドレスとホスト名の置換
		try {
			// 置換元となっている文章に、IPアドレスとノード名の置換用文字列が存在する場合
			if(retText.indexOf(NotifySubstitutionParameterConstant.IP_ADDRESS) != -1
					|| retText.indexOf(NotifySubstitutionParameterConstant.NODE) != -1){

				String nodeName = null;
				String ipNetworkNumber = null;

				String facilityId = info.getFacilityId();

				if(facilityId != null && !facilityId.equals("")){

					FacilityLocal facility = FacilityUtil.getLocalHome().findByPrimaryKey(facilityId);

					// 対象ファシリティIDがノードである場合
					if(facility != null && facility.isNode()){

						// ノード名の取得
						nodeName = facility.getNode().getNodeName();

						// IPアドレスの取得
						int version = 4;
						if(facility.getNode().getIpAddressVersion() != null){
							version = facility.getNode().getIpAddressVersion();
						}

						// 入力されているバージョンを比較し、対応するIPアドレスを取得する
						if(version == 4) {
							ipNetworkNumber = facility.getNode().getIpAddressV4();
						}
						else {
							ipNetworkNumber = facility.getNode().getIpAddressV6();
						}
					}
				}

				// ノード名の置換
				if(nodeName != null && !nodeName.equals("")) {
					retText = retText.replace(NotifySubstitutionParameterConstant.NODE, nodeName);
					if(m_log.isDebugEnabled()){
						m_log.debug("TextReplacer.substitution() : replase NODE text = " + retText);
					}
				}
				// IPアドレスの置換
				if(ipNetworkNumber != null && !ipNetworkNumber.equals("")) {
					retText = retText.replace(NotifySubstitutionParameterConstant.IP_ADDRESS, ipNetworkNumber);
					if(m_log.isDebugEnabled()){
						m_log.debug("TextReplacer.substitution() : replase IP_ADDRESS text = " + retText);
					}
				}

			} 

		}
		catch (NamingException e) {
			throw e;
		} 
		catch (FinderException e) {
			throw e;
		}

		return retText;
	}
	
}
