/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.performance.job;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import com.clustercontrol.performance.ejb.session.CollectorControllerLocal;
import com.clustercontrol.performance.ejb.session.CollectorControllerUtil;

/**
 * リポジトリ情報に変更があった場合に性能管理機能側の設定変更を行うクラス（Quartzに登録します）
 * 
 * @version 3.2.0
 * @since 3.2.0
 */
public class RepositoryCheckJob implements Job{
	protected static Log m_log = LogFactory.getLog( RepositoryCheckJob.class );

	/**
	 * Qurtzからコールバックされるメソッド
	 * リポジトリに変更があったか否かをチェックします。
	 * 変更があった場合は各収集ID毎の収集用EJBが保持しているスコープのキャッシュを変更します。
	 */
	public void execute(JobExecutionContext context) throws JobExecutionException {	
		// デバッグログ出力
		m_log.debug("RepositoryCheckJob Job Execute : start.");
		
		try {
			// リポジトリ情報の変更をチェックし、変更があった場合はスコープツリー情報を更新する
			CollectorControllerLocal ctrl = CollectorControllerUtil.getLocalHome().create();
			ctrl.refreshScopeTree();
		} catch (CreateException e) {
			m_log.error(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.error(e.getMessage(), e);
		} catch (Exception e) {
			m_log.error(e.getMessage(), e);
		}
			
		// デバッグログ出力
		m_log.debug("RepositoryCheckJob Job Execute : end.");
	}
}
