/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.ejb.entity;

import javax.ejb.EntityBean;

/**
 * 収集毎の収集項目の情報を保持するEntity Bean <BR>
 * @ejb.bean name="CollectorCalcMethodMst"
 *           jndi-name="CollectorCalcMethodMst"
 *           type="CMP"
 *           view-type="local"
 *           schema="CollectorCalcMethodMst" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="calcMethod"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 *  
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_collector_calc_method_mst"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 *  
 * @jboss.read-only read-only="true"
 *  
 * @ejb.permission
 *    unchecked="true"
 *     
 * @ejb.persistence 
 *    table-name="cc_collector_calc_method_mst"  
 *           
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorCalcMethodMst as a"  
 *    signature="java.util.Collection findAll()"  
 *
 * @ejb.pk class="java.lang.String"
 */
public abstract class CollectorCalcMethodMstBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public java.lang.String ejbCreate(
			String calcMethod,
			String className,
			String expression
			) throws javax.ejb.CreateException {
		
		this.setCalcMethod(calcMethod);
		this.setClassName(className);
		this.setExpression(expression);

		return null;
	}
	
	/**
	 * コンストラクター
	 * @param calcMethod 計算方法
	 * @param className クラス名
	 * @param expression 計算式
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String calcMethod,
			String className,
			String expression
			) throws javax.ejb.CreateException {
	}
	
	/**
	 * 計算方法を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="calc_method"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the calcMethod.
	 */
	public abstract String getCalcMethod();

	/**
	 * 計算方法を設定します。
	 * 
	 * @param calcMethod The calcMethod to set.
	 */
	public abstract void setCalcMethod(String calcMethod);

	/**
	 * クラス名を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="class_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the className.
	 */
	public abstract String getClassName();

	/**
	 * クラス名を設定します。
	 * 
	 * @param className The className to set.
	 */
	public abstract void setClassName(String className);

	/**
	 * 計算式を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="expression"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="text"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the expression.
	 */
	public abstract String getExpression();

	/**
	 * 計算式を設定します。
	 * 
	 * @param expression The expression to set.
	 */
	public abstract void setExpression(String expression);

}
