/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.ejb.entity;

import javax.ejb.EntityBean;

/**
 * 収集項目コードの定義情報を保持するEntity Bean <BR>
 * @ejb.bean name="CollectorItemCodeMst"
 *           jndi-name="CollectorItemCodeMst"
 *           type="CMP"
 *           view-type="local"
 *           schema="CollectorItemCodeMst" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="itemCode"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 *    
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_collector_item_code_mst"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 *  
 *  @jboss.read-only read-only="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_collector_item_code_mst"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorItemCodeMst as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.pk class="java.lang.String"
 */
public abstract class CollectorItemCodeMstBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public java.lang.String ejbCreate(
			String itemCode,
			String categoryCode,
			String parentItemCode,
			String itemName,
			String measure,
			Integer deviceSupport,
			String deviceType,
			Integer graphRange
			) throws javax.ejb.CreateException {
		
		this.setItemCode(itemCode);
		this.setCategoryCode(categoryCode);
		this.setParentItemCode(parentItemCode);
		this.setItemName(itemName);
		this.setMeasure(measure);
		this.setDeviceSupport(deviceSupport);
		this.setDeviceType(deviceType);
		this.setGraphRange(graphRange);
		
		return null;
	}
	
	/**
	 * コンストラクター
	 * @param itemCode 収集項目コード
	 * @param categoryCode カテゴリコード
	 * @param parentItemCode 親コード
	 * @param itemName 収集項目名
	 * @param measure 単位
	 * @param deviceSupport デバイスのサポート
	 * @param deviceType デバイス種別
	 * @param graphRange グラフレンジ
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String itemCode,
			String categoryCode,
			String parentItemCode,
			String itemName,
			String measure,
			Integer deviceSupport,
			String deviceType,
			Integer graphRange
			) throws javax.ejb.CreateException {
	}
	
	/**
	 * 収集項目コードを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="item_code"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the itemCode.
	 */
	public abstract String getItemCode();

	/**
	 * 収集項目コードを設定します。
	 * 
	 * @param itemCode The itemCode to set.
	 */
	public abstract void setItemCode(String itemCode);

	/**
	 * カテゴリコードを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="category_code"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the categoryCode.
	 */
	public abstract String getCategoryCode();

	/**
	 * カテゴリコードを設定します。
	 * 
	 * @param categoryCode The categoryCode to set.
	 */
	public abstract void setCategoryCode(String categoryCode);

	/**
	 * 親コードを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="parent_item_code"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the parentItemCode.
	 */
	public abstract String getParentItemCode();

	/**
	 * 親コードを設定します。
	 * 
	 * @param parentItemCode The parentItemCode to set.
	 */
	public abstract void setParentItemCode(String parentItemCode);

	/**
	 * 収集項目名を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="item_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the itemName.
	 */
	public abstract String getItemName();

	/**
	 * 収集項目名を設定します。
	 * 
	 * @param itemName The itemName to set.
	 */
	public abstract void setItemName(String itemName);

	/**
	 * 単位を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="measure"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the measure.
	 */
	public abstract String getMeasure();

	/**
	 * 単位を設定します。
	 * 
	 * @param measure The measure to set.
	 */
	public abstract void setMeasure(String measure);

	/**
	 * デバイスのサポートを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="device_support"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the deviceSupport.
	 */
	public abstract Integer getDeviceSupport();

	/**
	 * デバイスのサポートを設定します。
	 * 
	 * @param deviceSupport The deviceSupport to set.
	 */
	public abstract void setDeviceSupport(Integer deviceSupport);

	/**
	 * デバイス種別を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="device_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the deviceType.
	 */
	public abstract String getDeviceType();

	/**
	 * デバイス種別を設定します。
	 * 
	 * @param deviceType The deviceType to set.
	 */
	public abstract void setDeviceType(String deviceType);

	/**
	 * グラフレンジを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="graph_range"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the graphRange.
	 */
	public abstract Integer getGraphRange();

	/**
	 * グラフレンジを設定します。
	 * 
	 * @param graphRange The graphRange to set.
	 */
	public abstract void setGraphRange(Integer graphRange);

}