/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.ejb.session;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Quartzから呼びだされてSNMP監視を実行するSession Bean<BR>
 * 
 * @ejb.bean name="MonitorPerfRunManagement"
 *           jndi-name="MonitorPerfRunManagement"
 *           type="Stateless"
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorPerfInfoLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=SnmpValueTypeMstLocal"
 * 
 * @ejb.permission
 *     unchecked="true"
 *        
 */
public abstract class MonitorPerfRunManagementBean implements SessionBean {
	
	protected static Log m_log = LogFactory.getLog( MonitorPerfRunManagementBean.class );

    /**
     * Quartzからのコールバックメソッド<BR>
     * 実際には呼ばれるだけで何もしない。
     * 
     * @ejb.interface-method
     * 
     * @param monitorTypeId 監視監視対象ID
     * @param monitorId 監視項目ID
     * @throws FinderException
     * @throws NamingException
     */
    public void run(String monitorTypeId, String monitorId) throws CreateException, FinderException, RemoveException, JMSException, NamingException {
    	
        m_log.debug("run()");
    }
}
