/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performance.util;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import com.clustercontrol.performance.ejb.bmp.CollectorLocalHome;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoLocalHome;

/**
 * JNDI経由でEJBインスタンスを取得するクラス
 *
 */
public class JNDIConnectionManager extends com.clustercontrol.commons.util.JNDIConnectionManager {
	
	/**
	 * CollectorクラスのHomeインタフェースを取得する。
	 * @return CollectorクラスのHomeインタフェース
	 * @throws NamingException
	 */
	public static CollectorLocalHome getCollectorLocalHome() throws NamingException {
		Object obj = null;
		InitialContext initialContext = null;
		
		// 可用性対応 取得できるまで10回を上限にリトライする
		for(int i=0; i<10; i++){
			try {
				initialContext = getInitialContext();
				
				try {
					obj = initialContext.lookup(CollectorLocalHome.JNDI_NAME);
				} catch (NamingException e) {
				}
			} finally {
				initialContext.close();
				
				if(obj != null){
					return (CollectorLocalHome)PortableRemoteObject.narrow(obj, CollectorLocalHome.class);
				} else {
					// 10秒待つ
					try {
						Thread.sleep(10000);
					} catch (InterruptedException e1) {
					}
				}
			}
		}
		
		throw new NamingException();
	}
	
	/**
	 * MonitorPerfInfoクラスのHomeインタフェースを取得する。
	 * 
	 * @return MonitorPerfInfoクラスのHomeインタフェース
	 * @throws NamingException
	 */
	public static MonitorPerfInfoLocalHome getMonitorPerfInfo() throws NamingException {
		InitialContext initialContext = getInitialContext();
		
		try {
			Object obj = initialContext.lookup(MonitorPerfInfoLocalHome.JNDI_NAME);
			return (MonitorPerfInfoLocalHome)PortableRemoteObject.narrow(obj, MonitorPerfInfoLocalHome.class);
		} finally {
			initialContext.close();
		}
	}
}
