/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.port.ejb.session;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.port.factory.RunMonitorPort;

/**
 * @ejb.bean name="MonitorPortRunManagement"
 *           jndi-name="MonitorPortRunManagement"
 *           type="Stateless"
 *           transaction-type="Container"
 *           
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorPortInfoLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorProtocolMasterLocal"
 * 
 * @ejb.permission
 *     unchecked="true"
 *        
 */
public abstract class MonitorPortRunManagementBean implements SessionBean {
	
	protected static Log m_log = LogFactory.getLog( MonitorPortRunManagementBean.class );
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}

    /**
     * Quartzからのコールバックメソッド
     * 
     * @ejb.interface-method
     * 
     * @param monitorTypeId 監視監視対象ID
     * @param monitorId 監視項目ID
     * @param monitorType 監視判定タイプ
     * @throws CreateException
     * @throws FinderException
     * @throws RemoveException
     * @throws JMSException
     * @throws NamingException
     * @throws NotSupportedException
     * @throws HeuristicMixedException
     * @throws HeuristicRollbackException
     * @throws RollbackException
     * @throws InvalidTransactionException
     * @throws SystemException
     * @version 2.4.0
     * @since 2.4.0
     */
    public void run(String monitorTypeId, String monitorId, Integer monitorType) throws CreateException, FinderException, RemoveException, JMSException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, SystemException {
        m_log.debug("run()");
        
        RunMonitorPort monitor = null;
		try {
			monitor = new RunMonitorPort();
		} catch (NamingException e) {
			m_log.warn("run() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw e;
		} catch (JMSException e) {
			m_log.warn("run() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw e;
		} catch (CreateException e) {
			m_log.warn("run() : " + e.getClass().getSimpleName() +
					", " + e.getMessage());
			m_context.setRollbackOnly();
			throw e;
		}
		if(monitor != null){
			try{
				monitor.run(monitorTypeId, monitorId);
			}catch(CreateException e){
				m_log.warn("run() : " + e.getClass().getSimpleName() +
						", " + e.getMessage());
				m_context.setRollbackOnly();
				throw e;
			}catch(RemoveException e){
				m_log.warn("run() : " + e.getClass().getSimpleName() +
						", " + e.getMessage());
				m_context.setRollbackOnly();
				throw e;
			}catch(JMSException e){
				m_log.warn("run() : " + e.getClass().getSimpleName() +
						", " + e.getMessage());
				m_context.setRollbackOnly();
				throw e;
			}catch(NamingException e){
				m_log.warn("run() : " + e.getClass().getSimpleName() +
						", " + e.getMessage());
				m_context.setRollbackOnly();
				throw e;
			}catch(NotSupportedException e){
				m_log.warn("run() : " + e.getClass().getSimpleName() +
						", " + e.getMessage());
				m_context.setRollbackOnly();
				throw e;
			}catch(HeuristicMixedException e){
				m_log.warn("run() : " + e.getClass().getSimpleName() +
						", " + e.getMessage());
				m_context.setRollbackOnly();
				throw e;
			}catch(HeuristicRollbackException e){
				m_log.warn("run() : " + e.getClass().getSimpleName() +
						", " + e.getMessage());
				m_context.setRollbackOnly();
				throw e;
			}catch(RollbackException e){
				m_log.warn("run() : " + e.getClass().getSimpleName() +
						", " + e.getMessage());
				m_context.setRollbackOnly();
				throw e;
			}catch(InvalidTransactionException e){
				m_log.warn("run() : " + e.getClass().getSimpleName() +
						", " + e.getMessage());
				m_context.setRollbackOnly();
				throw e;
			}catch(SystemException e){
				m_log.warn("run() : " + e.getClass().getSimpleName() +
						", " + e.getMessage());
				m_context.setRollbackOnly();
				throw e;
			} catch (IllegalStateException e) {
				m_log.warn("run() : " + e.getClass().getSimpleName() +
						", " + e.getMessage());
				m_context.setRollbackOnly();
				throw e;
			} catch (FinderException e) {
				m_log.warn("run() : " + e.getClass().getSimpleName() +
						", " + e.getMessage());
				m_context.setRollbackOnly();
				throw e;
			}
		}
  
    }
}
