/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.port.factory;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.ModifyMonitorNumericValueType;
import com.clustercontrol.port.bean.PortCheckInfo;
import com.clustercontrol.port.ejb.entity.MonitorPortInfoLocal;
import com.clustercontrol.port.ejb.entity.MonitorPortInfoPK;
import com.clustercontrol.port.ejb.entity.MonitorPortInfoUtil;

/**
 * port監視情報更新クラス
 *
 * @version 2.4.0
 * @since 2.4.0
 */
public class ModifyMonitorPort extends ModifyMonitorNumericValueType{
	
	protected static Log m_log = LogFactory.getLog( ModifyMonitorPort.class );
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.ModifyMonitor#modifyCheckInfo()
	 */
	@Override
	public boolean modifyCheckInfo() throws CreateException, FinderException, NamingException {
		
		// port監視情報を取得
		MonitorPortInfoPK pk = new MonitorPortInfoPK(m_monitorInfo.getMonitorId(), m_monitorInfo.getMonitorTypeId());
		MonitorPortInfoLocal portLocal = MonitorPortInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// port監視情報を設定
		PortCheckInfo port = m_monitorInfo.getPortCheckInfo();
		portLocal.setPortNo(port.getPortNo());  //ポート番号
		portLocal.setRunCount(port.getRunCount());
		portLocal.setRunInterval(port.getRunInterval());
		portLocal.setTimeout(port.getTimeout());
		portLocal.setServiceId(port.getServiceId());
		
		return true;
	}
}
