/*
 
Copyright (C) since 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.repository.ejb.entity.NodeLocal;

/**
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="Facility" 
 *    jndi-name="Facility"
 *    type="CMP" 
 *    view-type="local"
 *    schema="FacilitySCHEMA" 
 *    cmp-version="2.x"
 *    primkey-field="facilityId" 
 *
 * @ejb.persistence 
 *    table-name="public.cc_cfg_facility"   
 *    
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM FacilitySCHEMA as a"  
 *    signature="java.util.Collection findAll()"
 *
 * @ejb.pk class="java.lang.String"
 *
 * @ejb.permission
 *    unchecked="true"
 *
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.read-ahead
 *    strategy="on-load"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_cfg_facility"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * <!-- end-xdoclet-definition -->
 * @generated
 **/

public abstract class FacilityBean implements javax.ejb.EntityBean {

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public java.lang.String ejbCreate(java.lang.String facilityId) throws javax.ejb.CreateException {
		// EJB 2.0 spec says return null for CMP ejbCreate methods.
		// TODO: YOU MUST INITIALIZE THE FIELDS FOR THE BEAN HERE. 
		// setMyField("Something"); 
		// begin-user-code
		setFacilityId(facilityId);
		setFacilityName("");
		setFacilityType(FacilityConstant.TYPE_SCOPE);
		setDescription("");
		setDisplaySortOrder(0);
		setValid(ValidConstant.TYPE_VALID);
		setCreateUserId("");
		setCreateDatetime(new java.sql.Timestamp(0));
		setModifyUserId("");
		setModifyDatetime(new java.sql.Timestamp(0));
		return null;
		// end-user-code
	}

	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field facilityId
	 *
	 * Returns the facilityId
	 * @return the facilityId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getFacilityId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the facilityId
	 * 
	 * @param java.lang.String the new facilityId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setFacilityId(java.lang.String facilityId);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field facilityName
	 *
	 * Returns the facilityName
	 * @return the facilityName
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getFacilityName();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the facilityName
	 * 
	 * @param java.lang.String the new facilityName value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setFacilityName(java.lang.String facilityName);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field facilityType
	 *
	 * Returns the facilityType
	 * @return the facilityType
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_type"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getFacilityType();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the facilityType
	 * 
	 * @param java.lang.Integer the new facilityType value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setFacilityType(java.lang.Integer facilityType);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field description
	 *
	 * Returns the description
	 * @return the description
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(256)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getDescription();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the description
	 * 
	 * @param java.lang.String the new description value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setDescription(java.lang.String description);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field displaySortOrder
	 *
	 * Returns the displaySortOrder
	 * @return the displaySortOrder
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="display_sort_order"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getDisplaySortOrder();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the displaySortOrder
	 * 
	 * @param java.lang.Integer the new displaySortOrder value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setDisplaySortOrder(java.lang.Integer displaySortOrder);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field valid
	 *
	 * Returns the valid
	 * @return the valid
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="valid"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="int2"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getValid();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the valid
	 * 
	 * @param java.lang.Integer the new valid value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setValid(java.lang.Integer valid);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field createUserId
	 *
	 * Returns the createUserId
	 * @return the createUserId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="create_user_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getCreateUserId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the createUserId
	 * 
	 * @param java.lang.String the new createUserId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setCreateUserId(java.lang.String createUserId);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field createDatetime
	 *
	 * Returns the createDatetime
	 * @return the createDatetime
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="create_datetime"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="timestamp"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.sql.Timestamp getCreateDatetime();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the createDatetime
	 * 
	 * @param java.sql.Timestamp the new createDatetime value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setCreateDatetime(java.sql.Timestamp createDatetime);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field modifyUserId
	 *
	 * Returns the modifyUserId
	 * @return the modifyUserId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="modify_user_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getModifyUserId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the modifyUserId
	 * 
	 * @param java.lang.String the new modifyUserId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setModifyUserId(java.lang.String modifyUserId);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field modifyDatetime
	 *
	 * Returns the modifyDatetime
	 * @return the modifyDatetime
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="modify_datetime"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="timestamp"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.sql.Timestamp getModifyDatetime();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the modifyDatetime
	 * 
	 * @param java.sql.Timestamp the new modifyDatetime value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setModifyDatetime(java.sql.Timestamp modifyDatetime);

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbLoad()
	 */
	public void ejbLoad() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbRemove()
	 */
	public void ejbRemove() throws RemoveException, EJBException,
			RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbStore()
	 */
	public void ejbStore() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException,
			RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/**
	 * 
	 */
	public FacilityBean() {
		// TODO Auto-generated constructor stub
	}

	//==========================================
	// Addon method
	//==========================================
	/**
	 * @ejb.interface-method
	 * @jboss.method-attributes
	 *    read-only="true"
	 */
	public boolean isNode() {
		if (getFacilityType() != null && getFacilityType() == FacilityConstant.TYPE_NODE) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * @ejb.interface-method
	 * @jboss.method-attributes
	 *    read-only="true"
	 */
	public boolean isScope() {
		if (getFacilityType() != null && getFacilityType() == FacilityConstant.TYPE_SCOPE) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * @ejb.interface-method
	 * @jboss.method-attributes
	 *    read-only="true"
	 */
	public boolean isValid() {
		if (getValid() != null && getValid() == ValidConstant.TYPE_VALID) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * @ejb.interface-method
	 */
	public void setValid(java.lang.Boolean valid) {
		if (valid != null && valid) {
			setValid(ValidConstant.TYPE_VALID);
		} else {
			setValid(ValidConstant.TYPE_INVALID);
		}
	}
	
	//==========================================
	// CMR fields
	//==========================================
	
	/**
	 * ファシリティの種別がノードの場合、そのノードエンティティを取得します。<BR>
	 * 
	 * @return ノードエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="facility-may-contain-node"
	 *    role-name="FacilityToNode"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 */
	public abstract NodeLocal getNode();
	
	
	/**
	 * ノードエンティティを格納します。<BR>
	 * 
	 * @param node ノードエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	public abstract void setNode(NodeLocal node);
	
	
	/**
	 * 親ファシリティとして対応するファシリティ関係エンティティを取得します。<BR>
	 * 
	 * @return ファシリティ関係エンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="facility-may-contain-facilityrelation-as-parent"
	 *    role-name="FacilityParentToFacilityRelation"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="parentFacilityId"
	 *    fk-column="facility_id"
	 */
	@SuppressWarnings("unchecked")
	public abstract java.util.Collection getFacilityRelationAsParent();
	
	/**
	 * ファシリティ関係エンティティを格納します。<BR>
	 * 
	 * @param facilityTree ファシリティ関係エンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	@SuppressWarnings("unchecked")
	public abstract void setFacilityRelationAsParent(java.util.Collection facilityTree);
	
	
	/**
	 * 子ファシリティとして対応するファシリティ関係エンティティを取得します。<BR>
	 * 
	 * @return ファシリティ関係エンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="facility-may-contain-facilityrelation-as-child"
	 *    role-name="FacilityChildToFacilityRelation"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="childFacilityId"
	 *    fk-column="facility_id"
	 */
	@SuppressWarnings("unchecked")
	public abstract java.util.Collection getFacilityRelationAsChild();
	
	/**
	 * ファシリティ関係エンティティを格納します。<BR>
	 * 
	 * @param facility ファシリティ関係エンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	@SuppressWarnings("unchecked")
	public abstract void setFacilityRelationAsChild(java.util.Collection facilityTree);
	
}
