/*
 
Copyright (C) since 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;

/**
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="Node" 
 *    jndi-name="Node"
 *    type="CMP" 
 *    view-type="local"
 *    schema="NodeSCHEMA" 
 *    cmp-version="2.x"
 *    primkey-field="facilityId" 
 *
 * @ejb.persistence 
 *    table-name="public.cc_cfg_node" 
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM NodeSCHEMA as a"  
 *    signature="java.util.Collection findAll()"  
 *
 * @ejb.finder 
 *   query=""  
 *   signature="java.util.Collection findByNodename(java.lang.String nodeName)"  
 *    
 * @jboss.query
 *   query="SELECT OBJECT(a) FROM NodeSCHEMA as a WHERE LCASE(a.nodeName) = ?1"  
 *   signature="java.util.Collection findByNodename(java.lang.String nodeName)"  
 *   
 * @ejb.pk class="java.lang.String"
 * 
 * @ejb.permission
 *    unchecked="true"
 *
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.read-ahead
 *    strategy="on-load"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_cfg_node"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * <!-- end-xdoclet-definition -->
 * @generated
 **/

public abstract class NodeBean implements javax.ejb.EntityBean {

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public java.lang.String ejbCreate(java.lang.String facilityId) throws javax.ejb.CreateException {
		// EJB 2.0 spec says return null for CMP ejbCreate methods.
		// TODO: YOU MUST INITIALIZE THE FIELDS FOR THE BEAN HERE. 
		// setMyField("Something"); 
		// begin-user-code
		setFacilityId(facilityId);
		setPlatformFamily("");
		setHardwareType("");
		setIconImage("");
		
		setSnmpPort(161);
		setSnmpCommunity("public");
		setSnmpVersion("2c");
		setSnmpTimeout(3000);
		setSnmpRetryCount(3);
		setSnmpProxy("");
		
		setWbemPort(5988);
		setWbemUser("root");
		setWbemUserPassword("");
		setWbemProtocol("http");
		setWbemTimeout(3000);
		setWbemRetryCount(3);
		
		setDhcpClient(ValidConstant.BOOLEAN_INVALID);
		setIpAddressType(-1);
		setIpAddressVersion(-1);
		setIpAddressV4("");
		setIpAddressV6("");
		
		setNodeName("");
		setOsName("");
		setOsRelease("");
		setOsVersion("");
		setCharacterSet("");
		
		setVirtualizationNodeType("");
		setVmManagementNode("");
		setVmIndex(-1);
		setVmName("");
		setVirtualizationSolution("");
		setVmId("");
		setVmUser("");
		setVmUserPassword("");
		setVmProtocol("");
		
		setAdministrator("");
		setContact("");
		
		return null;
		// end-user-code
	}

	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field facilityId
	 *
	 * Returns the facilityId
	 * @return the facilityId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getFacilityId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the facilityId
	 * 
	 * @param java.lang.String the new facilityId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setFacilityId(java.lang.String facilityId);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field platformFamily
	 *
	 * Returns the platformFamily
	 * @return the platformFamily
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="platform_family"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getPlatformFamily();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the platformFamily
	 * 
	 * @param java.lang.String the new platformFamily value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setPlatformFamily(java.lang.String platformFamily);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field hardwareType
	 *
	 * Returns the hardwareType
	 * @return the hardwareType
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="hardware_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getHardwareType();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the hardwareType
	 * 
	 * @param java.lang.String the new hardwareType value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setHardwareType(java.lang.String hardwareType);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field iconImage
	 *
	 * Returns the iconImage
	 * @return the iconImage
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="icon_image"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(256)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getIconImage();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the iconImage
	 * 
	 * @param java.lang.String the new iconImage value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setIconImage(java.lang.String iconImage);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field snmpPort
	 *
	 * Returns the snmpPort
	 * @return the snmpPort
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="snmp_port"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getSnmpPort();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the snmpPort
	 * 
	 * @param java.lang.Integer the new snmpPort value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setSnmpPort(java.lang.Integer snmpPort);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field snmpCommunity
	 *
	 * Returns the snmpCommunity
	 * @return the snmpCommunity
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="snmp_community"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getSnmpCommunity();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the snmpCommunity
	 * 
	 * @param java.lang.String the new snmpCommunity value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setSnmpCommunity(java.lang.String snmpCommunity);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field snmpVersion
	 *
	 * Returns the snmpVersion
	 * @return the snmpVersion
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="snmp_version"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(8)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getSnmpVersion();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the snmpVersion
	 * 
	 * @param java.lang.String the new snmpVersion value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setSnmpVersion(java.lang.String snmpVersion);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field snmpTimeout
	 *
	 * Returns the snmpTimeout
	 * @return the snmpTimeout
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="snmp_timeout"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getSnmpTimeout();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the snmpTimeout
	 * 
	 * @param java.lang.Integer the new snmpTimeout value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setSnmpTimeout(java.lang.Integer snmpTimeout);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field snmpRetryCount
	 *
	 * Returns the snmpRetryCount
	 * @return the snmpRetryCount
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="snmp_retry_count"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getSnmpRetryCount();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the snmpRetryCount
	 * 
	 * @param java.lang.Integer the new snmpRetryCount value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setSnmpRetryCount(java.lang.Integer snmpRetryCount);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field snmpProxy
	 *
	 * Returns the snmpProxy
	 * @return the snmpProxy
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="snmp_proxy"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(256)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getSnmpProxy();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the snmpProxy
	 * 
	 * @param java.lang.String the new snmpProxy value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setSnmpProxy(java.lang.String snmpProxy);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field wbemUser
	 *
	 * Returns the wbemUser
	 * @return the wbemUser
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="wbem_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getWbemUser();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the wbemUser
	 * 
	 * @param java.lang.String the new wbemUser value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setWbemUser(java.lang.String wbemUser);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field wbemUserPassword
	 *
	 * Returns the wbemUserPassword
	 * @return the wbemUserPassword
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="wbem_user_password"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getWbemUserPassword();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the wbemUserPassword
	 * 
	 * @param java.lang.String the new wbemUserPassword value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setWbemUserPassword(java.lang.String wbemUserPassword);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field wbemPort
	 *
	 * Returns the wbemPort
	 * @return the wbemPort
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="wbem_port"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getWbemPort();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the wbemPort
	 * 
	 * @param java.lang.Integer the new wbemPort value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setWbemPort(java.lang.Integer wbemPort);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field wbemProtocol
	 *
	 * Returns the wbemProtocol
	 * @return the wbemProtocol
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="wbem_protocol"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getWbemProtocol();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the wbemProtocol
	 * 
	 * @param java.lang.String the new wbemProtocol value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setWbemProtocol(java.lang.String wbemProtocol);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field wbemTimeout
	 *
	 * Returns the wbemTimeout
	 * @return the wbemTimeout
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="wbem_timeout"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getWbemTimeout();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the wbemTimeout
	 * 
	 * @param java.lang.Integer the new wbemTimeout value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setWbemTimeout(java.lang.Integer wbemTimeout);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field wbemRetryCount
	 *
	 * Returns the wbemRetryCount
	 * @return the wbemRetryCount
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="wbem_retry_count"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getWbemRetryCount();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the wbemRetryCount
	 * 
	 * @param java.lang.Integer the new wbemRetryCount value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setWbemRetryCount(java.lang.Integer wbemRetryCount);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field dhcpClient
	 *
	 * Returns the dhcpClient
	 * @return the dhcpClient
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="dhcp_client"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="int2"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getDhcpClient();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the dhcpClient
	 * 
	 * @param java.lang.Integer the new dhcpClient value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setDhcpClient(java.lang.Integer dhcpClient);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field ipAddressType
	 *
	 * Returns the ipAddressType
	 * @return the ipAddressType
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="ip_address_type"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getIpAddressType();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the ipAddressType
	 * 
	 * @param java.lang.Integer the new ipAddressType value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setIpAddressType(java.lang.Integer ipAddressType);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field ipAddressVersion
	 *
	 * Returns the ipAddressVersion
	 * @return the ipAddressVersion
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="ip_address_version"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="int2"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getIpAddressVersion();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the ipAddressVersion
	 * 
	 * @param java.lang.Integer the new ipAddressVersion value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setIpAddressVersion(java.lang.Integer ipAddressVersion);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field ipAddressV4
	 *
	 * Returns the ipAddressV4
	 * @return the ipAddressV4
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="ip_address_v4"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(16)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getIpAddressV4();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the ipAddressV4
	 * 
	 * @param java.lang.String the new ipAddressV4 value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setIpAddressV4(java.lang.String ipAddressV4);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field ipAddressV6
	 *
	 * Returns the ipAddressV6
	 * @return the ipAddressV6
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="ip_address_v6"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(40)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getIpAddressV6();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the ipAddressV6
	 * 
	 * @param java.lang.String the new ipAddressV6 value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setIpAddressV6(java.lang.String ipAddressV6);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field nodeName
	 *
	 * Returns the nodeName
	 * @return the nodeName
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="node_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(128)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getNodeName();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the nodeName
	 * 
	 * @param java.lang.String the new nodeName value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setNodeName(java.lang.String nodeName);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field osName
	 *
	 * Returns the osName
	 * @return the osName
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="os_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(256)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getOsName();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the osName
	 * 
	 * @param java.lang.String the new osName value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setOsName(java.lang.String osName);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field osRelease
	 *
	 * Returns the osRelease
	 * @return the osRelease
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="os_release"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(256)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getOsRelease();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the osRelease
	 * 
	 * @param java.lang.String the new osRelease value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setOsRelease(java.lang.String osRelease);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field osVersion
	 *
	 * Returns the osVersion
	 * @return the osVersion
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="os_version"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(256)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getOsVersion();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the osVersion
	 * 
	 * @param java.lang.String the new osVersion value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setOsVersion(java.lang.String osVersion);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field characterSet
	 *
	 * Returns the characterSet
	 * @return the characterSet
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="character_set"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(16)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getCharacterSet();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the characterSet
	 * 
	 * @param java.lang.String the new characterSet value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setCharacterSet(java.lang.String characterSet);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field virtualizationNodeType
	 *
	 * Returns the virtualizationNodeType
	 * @return the virtualizationNodeType
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="virtualization_node_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getVirtualizationNodeType();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the virtualizationNodeType
	 * 
	 * @param java.lang.String the new virtualizationNodeType value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setVirtualizationNodeType(
			java.lang.String virtualizationNodeType);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field vmManagementNode
	 *
	 * Returns the vmManagementNode
	 * @return the vmManagementNode
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="vm_management_node"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getVmManagementNode();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the vmManagementNode
	 * 
	 * @param java.lang.String the new vmManagementNode value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setVmManagementNode(java.lang.String vmManagementNode);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field vmIndex
	 *
	 * Returns the vmIndex
	 * @return the vmIndex
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="vm_index"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getVmIndex();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the vmIndex
	 * 
	 * @param java.lang.Integer the new vmIndex value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setVmIndex(java.lang.Integer vmIndex);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field vmName
	 *
	 * Returns the vmName
	 * @return the vmName
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="vm_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getVmName();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the vmName
	 * 
	 * @param java.lang.String the new vmName value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setVmName(java.lang.String vmName);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field virtualizationSolution
	 *
	 * Returns the virtualizationSolution
	 * @return the virtualizationSolution
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="virtualization_solution"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getVirtualizationSolution();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the virtualizationSolution
	 * 
	 * @param java.lang.String the new virtualizationSolution value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setVirtualizationSolution(
			java.lang.String virtualizationSolution);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field vmId
	 *
	 * Returns the vmId
	 * @return the vmId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="vm_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getVmId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the vmId
	 * 
	 * @param java.lang.String the new vmId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setVmId(java.lang.String vmId);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field vmUser
	 *
	 * Returns the vmUser
	 * @return the vmUser
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="vm_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getVmUser();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the vmUser
	 * 
	 * @param java.lang.String the new vmUser value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setVmUser(java.lang.String vmUser);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field vmUserPassword
	 *
	 * Returns the vmUserPassword
	 * @return the vmUserPassword
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="vm_user_password"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getVmUserPassword();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the vmUserPassword
	 * 
	 * @param java.lang.String the new vmUserPassword value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setVmUserPassword(java.lang.String vmUserPassword);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field vmProtocol
	 *
	 * Returns the vmProtocol
	 * @return the vmProtocol
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="vm_protocol"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getVmProtocol();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the vmProtocol
	 * 
	 * @param java.lang.String the new vmProtocol value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setVmProtocol(java.lang.String vmProtocol);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field administrator
	 *
	 * Returns the administrator
	 * @return the administrator
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="administrator"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(256)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getAdministrator();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the administrator
	 * 
	 * @param java.lang.String the new administrator value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setAdministrator(java.lang.String administrator);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field contact
	 *
	 * Returns the contact
	 * @return the contact
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="contact"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(1024)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getContact();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the contact
	 * 
	 * @param java.lang.String the new contact value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setContact(java.lang.String contact);

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbLoad()
	 */
	public void ejbLoad() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbRemove()
	 */
	public void ejbRemove() throws RemoveException, EJBException,
			RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbStore()
	 */
	public void ejbStore() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException,
			RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/**
	 * 
	 */
	public NodeBean() {
		// TODO Auto-generated constructor stub
	}
	
	//==========================================
	// Addon method
	//==========================================
	
	/**
	 * @ejb.interface-method
	 * @jboss.method-attributes
	 *    read-only="true"
	 */
	public boolean isDhcpClient() {
		if (getDhcpClient() != null && getDhcpClient() == ValidConstant.TYPE_VALID) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * @ejb.interface-method
	 */
	public void setDhcpClient(java.lang.Boolean valid) {
		if (valid != null && valid) {
			setDhcpClient(ValidConstant.TYPE_VALID);
		} else {
			setDhcpClient(ValidConstant.TYPE_INVALID);
		}
	}
	

	//==========================================
	// CMR fields
	//==========================================
	
	/**
	 * ノードが対応するファシリティエンティティを取得します。<BR>
	 * 
	 * @return ファシリティエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="facility-may-contain-node"
	 *    role-name="NodeToFacility"
	 *    cascade-delete="true"
	 * 
	 * @jboss.relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 */
	public abstract FacilityLocal getFacility();
	
	/**
	 * ファシリティエンティティを格納します。<BR>
	 * 
	 * @param facility ファシリティエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	public abstract void setFacility(FacilityLocal facility);
	
	/**
	 * ノードが保持するホスト名エンティティを取得します。<BR>
	 * 
	 * @return ホスト名エンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="node-may-contain-hostname"
	 *    role-name="NodeToHostname"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 */
	@SuppressWarnings("unchecked")
	public abstract java.util.Collection getNodeHostname();
	
	/**
	 * ホスト名エンティティを格納します。<BR>
	 * 
	 * @param nodeHostname ホスト名エンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	@SuppressWarnings("unchecked")
	public abstract void setNodeHostname(java.util.Collection nodeHostname);
	
	/**
	 * ノードが保持するデバイスエンティティを取得します。<BR>
	 * 
	 * @return デバイスエンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="node-may-contain-device"
	 *    role-name="NodeToDevice"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 */
	@SuppressWarnings("unchecked")
	public abstract java.util.Collection getNodeDevice();
	
	/**
	 * デバイスエンティティを格納します。<BR>
	 * 
	 * @param nodeDevice デバイスエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	@SuppressWarnings("unchecked")
	public abstract void setNodeDevice(java.util.Collection nodeDevice);
	
	/**
	 * ノードが保持するファイルシステムエンティティを取得します。<BR>
	 * 
	 * @return ファイルシステムエンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="node-may-contain-filesystem"
	 *    role-name="NodeToFilesystem"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 */
	@SuppressWarnings("unchecked")
	public abstract java.util.Collection getNodeFilesystem();
	
	/**
	 * ファイルシステムエンティティを格納します。<BR>
	 * 
	 * @param nodeFilesystem ファイルシステムエンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	@SuppressWarnings("unchecked")
	public abstract void setNodeFilesystem(java.util.Collection nodeFilesystem);
	
	/**
	 * ノードが保持する備考エンティティを取得します。<BR>
	 * 
	 * @return 備考エンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="node-may-contain-note"
	 *    role-name="NodeToNote"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 */
	@SuppressWarnings("unchecked")
	public abstract java.util.Collection getNodeNote();
	
	/**
	 * 備考エンティティを格納します。<BR>
	 * 
	 * @param note ファイルシステムエンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	@SuppressWarnings("unchecked")
	public abstract void setNodeNote(java.util.Collection note);
}
