/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.FacilityNotFoundException;
import com.clustercontrol.repository.bean.NodeDeviceInfo;
import com.clustercontrol.repository.bean.NodeFilesystemInfo;
import com.clustercontrol.repository.bean.NodeHostnameInfo;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.bean.NodeNoteInfo;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.NodeDeviceLocal;
import com.clustercontrol.repository.ejb.entity.NodeFilesystemLocal;
import com.clustercontrol.repository.ejb.entity.NodeHostnameLocal;
import com.clustercontrol.repository.ejb.entity.NodeLocal;
import com.clustercontrol.repository.ejb.entity.NodeNoteLocal;
import com.clustercontrol.repository.ejb.entity.NodeUtil;

/**
 * ノード用プロパティを作成するクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeProperty {
	
	private static Log m_log = LogFactory.getLog(NodeProperty.class);
	
	/** ----- 初期値キャッシュ ----- */
	/*
	private static HashMap<Locale, HashMap<Integer, Property>> cachedInitProperty = null;
	
	static {
		cachedInitProperty = new HashMap<Locale, HashMap<Integer, Property>>();
	}
	*/
	
	/**
	 * 与えられたファシリティIDに基づき、該当するノード情報を返す。<BR>
	 * 
	 * @param facilityId ファシリティID
	 * @param mode ノード情報扱い種別（参照、追加、変更）
	 * @return ノード情報
	 * @throws FacilityNotFoundException 
	 * @throws FinderException
	 * @throws NamingException
	 */
	public static NodeInfo getProperty(String facilityId) throws FacilityNotFoundException {
		/** ローカル変数 */
		NodeInfo property = null;
		NodeLocal node = null;
		FacilityLocal facility = null;
		
		/** メイン処理 */
		property = new NodeInfo();
		
		if (facilityId == null || facilityId.compareTo("") == 0) {
			return property;
		}
		
		try {
			node = NodeUtil.getLocalHome().findByPrimaryKey(facilityId);
			facility = node.getFacility();
		} catch (FinderException e) {
			throw new FacilityNotFoundException(e);
		
		} catch (Exception e) {
			m_log.warn("failure to get node's properties. (facilityId = " + facilityId + ")");
			throw new EJBException("failure to get node's properties. (facilityId = " + facilityId + ")");
		}
		
		// ----- ファシリティ関連 -----
		// ファシリティID
		property.setFacilityId(facility.getFacilityId());
		
		// ファシリティ名
		property.setFacilityName(facility.getFacilityName());
		
		// 説明
		property.setDescription(facility.getDescription());
		
		// 有効/無効
		property.setValid(facility.isValid());
		
		// 登録ユーザID
		property.setCreateUserId(facility.getCreateUserId());
		
		// 登録日時
		if (facility.getCreateDatetime().getTime() != 0) {
			property.setCreateDatetime(new Date(facility.getCreateDatetime().getTime()));
		}
		
		// 最終更新ユーザID
		property.setModifyUserId(facility.getModifyUserId());
		
		// 最終更新日時
		if (facility.getModifyDatetime().getTime() != 0) {
			property.setModifyDatetime(new Date(facility.getModifyDatetime().getTime()));
		}
		
		// ----- ノード関連 -----
		// プラットフォーム
		property.setPlatformFamily(node.getPlatformFamily());
		
		// H/Wタイプ
		property.setHardwareType(node.getHardwareType());
		
		// 画面アイコンイメージ
		property.setIconImage(node.getIconImage());	
		
		// ----- SNMP関連 -----
		// SNMPポート番号
		if (node.getSnmpPort() != -1) {
			property.setSnmpPort(node.getSnmpPort());
		}
		
		// SNMPコミュニティ名
		property.setSnmpCommunity(node.getSnmpCommunity());
		
		// SNMPバージョン
		property.setSnmpVersion(node.getSnmpVersion());
		
		// SNMPタイムアウト
		if (node.getSnmpTimeout() != -1) {
			property.setSnmpTimeout(node.getSnmpTimeout());
		}
		
		// SNMPリトライ回数
		if (node.getSnmpRetryCount() != -1) {
			property.setSnmpRetryCount(node.getSnmpRetryCount());
		}
		
		// SNMPプロキシ
		property.setSnmpProxy(node.getSnmpProxy());
		
		// ----- WBEM関連 -----
		// WBEM接続ポート番号
		if (node.getWbemPort() != -1) {
			property.setWbemPort(node.getWbemPort());
		}
		
		// WBEM接続ユーザ
		property.setWbemUser(node.getWbemUser());
		
		// WBEM接続ユーザパスワード
		property.setWbemUserPassword(node.getWbemUserPassword());
		
		// WBEM接続プロトコル
		property.setWbemProtocol(node.getWbemProtocol());
		
		// WBEM接続タイムアウト
		if (node.getWbemTimeout() != -1) {
			property.setWbemTimeout(node.getWbemTimeout());
		}
		
		// WBEM接続リトライ回数
		if (node.getWbemRetryCount() != -1) {
			property.setWbemRetryCount(node.getWbemRetryCount());
		}
		
		// ----- IPアドレス関連 -----
		// DHCPクライアント
		property.setDhcpClient(node.isDhcpClient());
		
		// IPタイプ
		if (node.getIpAddressType() != -1) {
			property.setIpAddressType(node.getIpAddressType());
		}
		
		// IPバージョン
		if (node.getIpAddressVersion() != -1) {
			property.setIpAddressVersion(node.getIpAddressVersion());
		}
		
		// IPアドレスV4
		property.setIpAddressV4(node.getIpAddressV4());
		
		// IPアドレスV6
		property.setIpAddressV6(node.getIpAddressV6());
		
		// ----- OS関連 -----
		// ノード名
		property.setNodeName(node.getNodeName());
		
		// OS名
		property.setOsName(node.getOsName());
		
		// OSリリース
		property.setOsRelease(node.getOsRelease());
		
		// OSバージョン
		property.setOsVersion(node.getOsVersion());
		
		// 文字セット
		property.setCharacterSet(node.getCharacterSet());
		
		// ----- VM関連 -----
		// 仮想化ノード種別
		property.setVirtualizationNodeType(node.getVirtualizationNodeType());
		
		// 仮想マシン管理ノード
		property.setVmManagementNode(node.getVmManagementNode());
		
		// 仮想マシンINDEX
		if (node.getVmIndex() != -1) {
			property.setVmIndex(node.getVmIndex());
		}
		
		// 仮想マシン名
		property.setVmName(node.getVmName());
		
		// 仮想化ソリューション
		property.setVirtualizationSolution(node.getVirtualizationSolution());
		
		// 仮想マシンID
		property.setVmId(node.getVmId());
		
		// 仮想化ソフト接続ユーザ
		property.setVmUser(node.getVmUser());
		
		// 仮想化ソフト接続ユーザパスワード
		property.setVmUserPassword(node.getVmUserPassword());
		
		// 仮想化ソフト接続プロトコル
		property.setVmProtocol(node.getVmProtocol());
		
		// ----- 管理情報関連 -----
		// 連絡先
		property.setContact(node.getContact());
		
		// 管理者
		property.setAdministrator(node.getAdministrator());
		
		// ----- ホスト名 -----
		ArrayList<NodeHostnameInfo> hostnameList = new ArrayList<NodeHostnameInfo>();
		if (node.getNodeHostname() != null) {
			for (NodeHostnameLocal nodeHostname : (Collection<NodeHostnameLocal>)node.getNodeHostname()) {
				// ホスト名
				hostnameList.add(new NodeHostnameInfo(nodeHostname.getHostname()));
			}
		}
		property.setNodeHostnameInfo(hostnameList);
		
		// ----- 備考 -----
		ArrayList<NodeNoteInfo> noteList = new ArrayList<NodeNoteInfo>();
		if (node.getNodeNote() != null) {
			int cnt = 0;
			for (NodeNoteLocal nodeNote : (Collection<NodeNoteLocal>)node.getNodeNote()) {
				// 備考
				noteList.add(new NodeNoteInfo(cnt, nodeNote.getNote()));
				cnt++;
			}
		}
		property.setNodeNoteInfo(noteList);
		
		// ----- デバイス情報 -----
		ArrayList<NodeDeviceInfo> deviceList = new ArrayList<NodeDeviceInfo>();
		if (node.getNodeDevice() != null) {
			int cnt = 0;
			for (NodeDeviceLocal nodeDevice : (Collection<NodeDeviceLocal>)node.getNodeDevice()) {
				NodeDeviceInfo device = new NodeDeviceInfo();
				
				// デバイス種別
				device.setDeviceType(nodeDevice.getDeviceType());
				
				// デバイスINDEX
				device.setDeviceIndex(nodeDevice.getDeviceIndex());
				
				// デバイス名
				device.setDeviceName(nodeDevice.getDeviceName());
				
				// デバイス表示名
				device.setDeviceDisplayName(nodeDevice.getDeviceDisplayName());
				
				// デバイスOID
				device.setDeviceSnmpOid(nodeDevice.getDeviceSnmpOid());
				
				// 説明
				device.setDeviceDescription(nodeDevice.getDeviceDescription());
				cnt++;
				deviceList.add(device);
			}
		}
		property.setNodeDeviceInfo(deviceList);
		
		// ---- ファイルシステム情報 -----
		ArrayList<NodeFilesystemInfo> filesystemList = new ArrayList<NodeFilesystemInfo>();
		if (node.getNodeFilesystem() != null) {
			int cnt = 0;
			for (NodeFilesystemLocal nodeFilesystem : (Collection<NodeFilesystemLocal>)node.getNodeFilesystem()) {
				NodeFilesystemInfo filesystem = new NodeFilesystemInfo();
				
				// ファイルシステムINDEX
				filesystem.setFsIndex(nodeFilesystem.getFsIndex());
				
				// マウント位置
				filesystem.setFsMountPoint(nodeFilesystem.getFsMountPoint());
				
				// ファイルシステム表示名
				filesystem.setFsDisplayName(nodeFilesystem.getFsDisplayName());
				
				// ファイルシステム種別
				filesystem.setFsType(nodeFilesystem.getFsType());
				
				// ファイルシステムOID
				filesystem.setFsSnmpOid(nodeFilesystem.getFsSnmpOid());
				
				// 説明
				filesystem.setFsDescription(nodeFilesystem.getFsDescription());
				cnt++;
				filesystemList.add(filesystem);
			}
		}
		property.setNodeFilesystemInfo(filesystemList);
		
		return property;
	}
}
