/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmp.factory;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.SelectMonitor;
import com.clustercontrol.snmp.bean.SnmpCheckInfo;
import com.clustercontrol.snmp.util.ControlSnmpInfo;

/**
 * SNMP監視 数値監視設定を検索するファクトリークラス<BR>
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class SelectMonitorSnmp extends SelectMonitor{
	
	protected static Log m_log = LogFactory.getLog( SelectMonitorSnmp.class );

	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.SelectMonitor#getCheckInfo()
	 */
	@Override
	public SnmpCheckInfo getSnmpCheckInfo() throws FinderException, NamingException{
		
		// SNMP監視情報を取得
		ControlSnmpInfo snmp = new ControlSnmpInfo(m_monitorId, m_monitorTypeId);
		return snmp.get();
	}
}
