package com.clustercontrol.snmptrap.ejb.entity;

import java.util.Collection;

import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.naming.NamingException;

/**
 * SNMPトラップ監視の設定情報（OID部分）を管理する　Entity Bean<BR>
 * @ejb.bean name="SnmpTrapOidInfo"
 *           jndi-name="SnmpTrapOidInfo"
 *           type="BMP"
 *           view-type="local"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config BMP EntityBean"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @ejb.dao class="com.clustercontrol.snmptrap.dao.SnmpTrapOidInfoDAO"
 * impl-class="com.clustercontrol.snmptrap.dao.SnmpTrapOidInfoDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *  
 */
public abstract class SnmpTrapOidInfoBean implements EntityBean {

	protected String monitorId;
	protected String mib;
	protected String trapOid;
	protected Integer genericId;
	protected Integer specificId;
	protected Integer validFlg;
	protected Integer priority;
	protected String logmsg;
	protected String descr;
	
	/**
	 * @ejb.create-method 
	 */
	public SnmpTrapOidInfoPK ejbCreate(
			String monitorId, 
			String mib, 
			String trapOid, 
			Integer genericId, 
			Integer specificId, 
			Integer validFlg, 
			Integer priority, 
			String logmsg, 
			String descr) throws javax.ejb.CreateException {
		
		this.monitorId = monitorId;
		this.mib = mib;
		this.trapOid = trapOid;
		this.genericId = genericId;
		this.specificId = specificId;
		this.validFlg = validFlg;
		this.priority = priority;
		this.logmsg = logmsg;
		this.descr = descr;
		
		return null;
	}
	


	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public SnmpTrapOidInfoPK ejbFindByPrimaryKey(SnmpTrapOidInfoPK pk) throws FinderException {
		return null;
	}
	
	public Collection ejbFindByMonitorId(String monitorId) throws FinderException {
		return null;
	}
	
	/**
	 * @return the monitorId
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public String getMonitorId() {
		return monitorId;
	}
	
	/**
	 * @param java.lang.String the new monitorId value
	 * @ejb.interface-method
	 */
	public void setMonitorId(String monitorId) {
		this.monitorId = monitorId;
	}
	
	/**
	 * @return the mib
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public String getMib() {
		return mib;
	}
	
	/**
	 * @param java.lang.String the new mib value
	 * @ejb.interface-method
	 */
	public void setMib(String mib) {
		this.mib = mib;
	}
	
	/**
	 * @return the trapOid
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public String getTrapOid() {
		return trapOid;
	}
	
	/**
	 * @param java.lang.String the new trapOid value
	 * @ejb.interface-method
	 */
	public void setTrapOid(String trapOid) {
		this.trapOid = trapOid;
	}
	
	/**
	 * @return the genericId
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public Integer getGenericId() {
		return genericId;
	}
	
	/**
	 * @param java.lang.String the new genericId value
	 * @ejb.interface-method
	 */
	public void setGenericId(Integer genericId) {
		this.genericId = genericId;
	}
	
	/**
	 * @return the specificId
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public Integer getSpecificId() {
		return specificId;
	}
	
	/**
	 * @param java.lang.String the new specificId value
	 * @ejb.interface-method
	 */
	public void setSpecificId(Integer specificId) {
		this.specificId = specificId;
	}
	
	/**
	 * @return the validFlg
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Integer getValidFlg() {
		return validFlg;
	}
	
	/**
	 * @param java.lang.Integer the new validFlg value
	 * @ejb.interface-method
	 */
	public void setValidFlg(Integer validFlg) {
		this.validFlg = validFlg;
	}
	
	/**
	 * @return the priority
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Integer getPriority() {
		return priority;
	}
	
	/**
	 * @param java.lang.Integer the new priority value
	 * @ejb.interface-method
	 */
	public void setPriority(Integer priority) {
		this.priority = priority;
	}
	
	/**
	 * @return the logmsg
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getLogmsg() {
		return logmsg;
	}
	
	/**
	 * @param java.lang.String the new logmsg value
	 * @ejb.interface-method
	 */
	public void setLogmsg(String logmsg) {
		this.logmsg = logmsg;
	}
	
	/**
	 * @return the descr
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getDescr() {
		return descr;
	}
	
	/**
	 * @param java.lang.String the new descr value
	 * @ejb.interface-method
	 */
	public void setDescr(String descr) {
		this.descr = descr;
	}
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * @ejb.interface-method view-type="local"
	 */
	public SnmpTrapInfoLocal getSnmpTrapInfo() throws FinderException, NamingException{
		SnmpTrapInfoLocal snmpTrapInfo = null;
		try {
			snmpTrapInfo = SnmpTrapInfoUtil.getLocalHome().findByPrimaryKey(new SnmpTrapInfoPK(getMonitorId()));
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		return snmpTrapInfo;
	}
}
