/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.vm;

import java.util.List;

import com.clustercontrol.sharedtable.DataTable;

/**
 * 監視管理・性能管理の仮想化ポーラーのインタフェース
 * VmwareプロジェクトやXenプロジェクトなどに、
 * このインタフェースを利用したクラスが実装される。
 * 
 * @version 3.1.0
 * @since 3.1.0
 */
public interface VmPollerImplInterface {
	
	/**
	 * インスタンス生成後に呼ぶこと！
	 * @param pollerProtocol
	 */
	public void init(String pollerProtocol);
	
	/**
	 * @param ipAddress
	 * @param vmNodeType
	 * @param vmManagementIp
	 * @param vmName
	 * @param user
	 * @param password
	 * @param protocol
	 * @param params
	 */
	public DataTable polling(
			String ipAddress,
			String vmNodeType,
			String vmManagementIp,
			String vmName,
			String user,
			String password,
			String protocol,
			List<String> params);
}