/*-----------------------------------------------------------------------------
 *
 *  convert.c - R[hϊW[
 *
 *    Copyright (c) 2003, Ryo.Sugahara / Algorithm Collection
 *                                        All rights reserved
 *
 *    {W[Weby[WuAlgorithm CollectionvɌfڂꂽ̂𗬗p
 *    č\̂łB
 *
 *    Algorithm Collection
 *      http://alfin.mine.utsunomiya-u.ac.jp/~niy/algo/index.html
 *
 *    This program is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU General Public License
 *    as published by the Free Software Foundation; either version 2
 *    of the License, or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307
 *
 *  Revision history:
 *    16-Apr-2003  
 *
 *----------------------------------------------------------------------------*/

/*
R[hʂ̔

֐

whatKanji  R[h̎ʂ𔻒肷

`

int whatKanji(unsigned char *str);



str  íj

֐l

̎ʂ\l
Estr̐擪pJȉꍇA֐l1
Estr̐擪2VtgJISR[h̏ꍇA֐l2
Estr̐擪2EUCpJiR[h̏ꍇA֐l4
Estr̐擪2EUCSpR[h̏ꍇA֐l8
Estr̐擪3VJIS(X0208-1983)VtgR[h̏ꍇA
@֐l16
Estr̐擪3JIS(X0208-1978)VtgR[h̏ꍇA
@֐l32
Estr̐擪3JIS[}(X0201)VtgR[h̏ꍇA
@֐l64
Estr̐擪3ASCII VtgR[h̏ꍇA֐l128
ẼP[XɋNꍇ́A֐l̘͂_a
ÊłȂꍇ́A֐l0

ӎ

piwhatKanji-test.cj
    whatKanji("");


    pJiR[h 0xa0 - 0xdf ̊ԂgB

    VtgJISR[h͑1oCgƂ 0x81 - 0x9f ܂ł 0xe0 - 0xfc ܂ŁA2oCgƂ 0x40 - 0xfc ܂Łi0x7fjgB ߁AVtgJIS͏L̔pR[hƍ݂łBA䕶 ƂĎg _iobNXbV܂͉~LjȂǂ2oCg ̗̈ɓĂ邽߂ɖ肪邱ƂB

    EUCR[h͑1A2oCgƂ 0xa1 - 0xfe ܂łł邪Ap JiɂẮA0x8e 𔼊pJȋOɂA2oCgŕ\ B

    AJISR[h7rbgnR[hł邽߁A̂悤ȃVtg R[hgāAZbg̐؂ւsAȊ\B

    @@@VtgR[hꗗ
    Zbg VtgR[h
    VJIS X0208-1983 ESC $ B
    JIS X0208-1978 ESC $ @
    JIS[} X0201 ESC ( J
    ASCII ESC ( B
*/

int whatKanji(unsigned char *str)
{
    int val = 0;
    unsigned char b1, b2, b3;

    b1 = *str++;
    b2 = *str++;
    b3 = *str;
    if (b1 == 0x1b) {
        if (b2 == '$' && b3 == 'B') return 16;
        if (b2 == '$' && b3 == '@') return 32;
        if (b2 == '(' && b3 == 'J') return 64;
        if (b2 == '(' && b3 == 'B') return 128;
        return 0;
    }
    if ( b1 >= 0xa0 && b1 <= 0xdf) val |= 1;
    if ((b1 >= 0x81 && b1 <= 0x9f ||
         b1 >= 0xe0 && b1 <= 0xfc) && 
        (b2 >= 0x40 && b2 <= 0xfc && b2 != 0x7f)) val |= 2;
    if (b1 == 0x8e && (b2 >= 0xa0 && b2 <= 0xdf)) val |= 4; 
    if ((b1 >= 0xa1 && b1 <= 0xfe) &&
        (b2 >= 0xa1 && b1 <= 0xfe)) val |= 8;

    return val;
}


/*
pJiSpJiɕϊ

֐

hankaku2zen  pJiSpJiɕϊ

`

unsigned int hankaku2zen(int hankaku);



hankaku  pJiR[hi0xA0-0xDFj

֐l

ΉSpJiJISR[hBϊłȂƂ0B

ӎ
    pJiR[h͈̔͂0xA00xDFB

pihankaku2zen-test.cj
    hankaku2zen(0xb1);
*/
unsigned int hankaku2zen(int hankaku)
{
    static unsigned int z[64] = {
        0x2121,0x2123,0x2156,0x2157,0x2122,0x2126,0x2572,0x2521,
        0x2523,0x2525,0x2527,0x2529,0x2563,0x2565,0x2567,0x2543,
        0x213c,0x2522,0x2524,0x2526,0x2528,0x252a,0x252b,0x252d,
        0x252f,0x2531,0x2533,0x2535,0x2537,0x2539,0x253b,0x253d,
        0x253f,0x2541,0x2544,0x2546,0x2548,0x254a,0x254b,0x254c,
        0x254d,0x254e,0x254f,0x2552,0x2555,0x2558,0x255b,0x255e,
        0x255f,0x2560,0x2561,0x2562,0x2564,0x2566,0x2568,0x2569,
        0x256a,0x256b,0x256c,0x256d,0x256f,0x2573,0x212b,0x212c };

    if (hankaku < 0xa0 || hankaku > 0xdf) return 0;
    return z[hankaku - 0xa0];
}

/*
pJiSpJiɕϊiΉŁj

֐

han2zen  pJiSpJiɕϊiΉŁj

`

int han2zen(unsigned int *zenkaku, unsigned char *str);



zenkaku  iójSpJiJISR[h
str      íjpJiR[hi0xA0-0xDFj܂߂

֐l

ϊʂɂĂ̕t
Estr̐擪pJiłȂꍇA֐l0
Estr̐擪pJiłi܂擪
@2EJȋgłȂjꍇA֐l1
Estr̐擪2EJȋgłꍇA
@֐l2

ӎ
    Ȅꍇ2̔pJi1̑SpJi ϊ

pihan2zen-test.cj
    unsigned int zenkaku;
    han2zen(&zenkaku, "\xc0\xde");


    pJi͎gȂƂɂ悤B̂ƂASpJi pJiɖ߂֐pӂ͂ȂBǂĂKvȕ 삵ĉB
*/
int han2zen(unsigned int *zenkaku, unsigned char *str)
{
    static unsigned int z[64] = {
        0x2121,0x2123,0x2156,0x2157,0x2122,0x2126,0x2572,0x2521,
        0x2523,0x2525,0x2527,0x2529,0x2563,0x2565,0x2567,0x2543,
        0x213c,0x2522,0x2524,0x2526,0x2528,0x252a,0x252b,0x252d,
        0x252f,0x2531,0x2533,0x2535,0x2537,0x2539,0x253b,0x253d,
        0x253f,0x2541,0x2544,0x2546,0x2548,0x254a,0x254b,0x254c,
        0x254d,0x254e,0x254f,0x2552,0x2555,0x2558,0x255b,0x255e,
        0x255f,0x2560,0x2561,0x2562,0x2564,0x2566,0x2568,0x2569,
        0x256a,0x256b,0x256c,0x256d,0x256f,0x2573,0x212b,0x212c};
    typedef struct {
        unsigned char han;
        unsigned int zen;
    } TBL;
    static TBL daku[] = {
        {0xb3,0x2574},{0xb6,0x252c},{0xb7,0x252e},{0xb8,0x2530},
        {0xb9,0x2532},{0xba,0x2534},{0xbb,0x2536},{0xbc,0x2538},
        {0xbd,0x253a},{0xbe,0x253c},{0xbf,0x253e},{0xc0,0x2540},
        {0xc1,0x2542},{0xc2,0x2545},{0xc3,0x2547},{0xc4,0x2549},
        {0xca,0x2550},{0xcb,0x2553},{0xcc,0x2556},{0xcd,0x2559},
        {0xce,0x255c},{0,0}};
    static TBL handaku[] = {
        {0xca,0x2551},{0xcb,0x2554},{0xcc,0x2557},{0xcd,0x255a},
        {0xce,0x255d},{0,0}};
    int i;

    if (*str < 0xa0 || *str > 0xdf) return 0;
    if (*(str+1) == 0xde) {           /*  */
        for (i = 0; daku[i].zen != 0; i++)
            if (*str == daku[i].han) {
                *zenkaku = daku[i].zen;
                return 2;
            }
    } else if (*(str+1) == 0xdf) {    /*  */
        for (i = 0; handaku[i].zen != 0; i++)
            if (*str == handaku[i].han) {
                *zenkaku = handaku[i].zen;
                return 2;
            }
    }
    
    *zenkaku = z[*str - 0xa0];
    return 1;
}

/*
VtgJISR[hJISR[hɕϊ

֐

sjis2jis  VtgJISR[hJISR[hɕϊ

`

unsigned int sjis2jis(unsigned int sjis);



sjis  VtgJISR[h

֐l

JISR[h

ӎ

pisjis2jis-test.cj
    sjis2jis(0x8abf);


    VtgJISR[h MicrosoftR[hƂ΂A݂ ƂłLgpĂ8rbgnR[hłAp\R ̕WR[hłB

    AJISR[h7rbgnR[hłAJISKiɂ ꂽ{̕WR[hî͂jłBƂɁAȁE ܂߂C^[lbgE[ɂ͕ʁAJISR[hg ĂB
*/
unsigned int sjis2jis(unsigned int sjis)
{
    unsigned int hib, lob;
    
    hib = (sjis >> 8) & 0xff;
    lob = sjis & 0xff;
    hib -= (hib <= 0x9f) ? 0x71 : 0xb1;
    hib = (hib << 1) + 1;
    if (lob > 0x7f) lob--;
    if (lob >= 0x9e) {
        lob -= 0x7d;
        hib++;
    } else lob -= 0x1f;

    return (hib << 8) | lob;
}

/*
VtgJISR[hEUCR[hɕϊ

֐

sjis2euc  VtgJISR[hEUCR[hɕϊ

`

unsigned int sjis2euc(unsigned int sjis);



sjis  VtgJISR[h

֐l

EUCR[h

ӎ

pisjis2euc-test.cj
    sjis2euc(0x8abf);


    VtgJISR[h MicrosoftR[hƂ΂A݂ ƂłLgpĂ8rbgnR[hłAp\R ̕WR[hłB

    AEUCR[hUNIXōLgĂ8rbgnR[h łAJISR[h̑1oCgA2oCg̗0x80Z ̂gpB
*/
unsigned int sjis2euc(unsigned int sjis)
{
    unsigned int hib, lob;
    
    hib = (sjis >> 8) & 0xff;
    lob = sjis & 0xff;
    hib -= (hib <= 0x9f) ? 0x71 : 0xb1;
    hib = (hib << 1) + 1;
    if (lob >= 0x9f) {
        lob -= 0x7e;
        hib++;
    } else if (lob > 0x7f) lob -= 0x20;
    else lob -= 0x1f;

    hib |= 0x80;
    lob |= 0x80;

    return (hib << 8) | lob;
}

/*
JISR[hVtgJISR[hɕϊ

֐

jis2sjis  JISR[hVtgJISR[hɕϊ

`

unsigned int jis2sjis(unsigned int jis);



jis  JISR[h

֐l

VtgJISR[h

ӎ

pijis2sjis-test.cj
    jis2sjis(0x3441);


    JISR[h7rbgnR[hłAJISKiɂ ꂽ{̕WR[hî͂jłBƂɁAȁE ܂߂C^[lbgE[ɂ͕ʁAJISR[hg ĂB

    AVtgJISR[h MicrosoftR[hƂ΂A݂ ƂłLgpĂ8rbgnR[hłAp\R ̕WR[hłB
*/
unsigned int jis2sjis(unsigned int jis)
{
    unsigned int hib, lob;
    
    hib = (jis >> 8) & 0xff;
    lob = jis & 0xff;
    lob += (hib & 1) ? 0x1f : 0x7d;
    if (lob >= 0x7f) lob++;
    hib = ((hib - 0x21) >> 1) + 0x81;
    if (hib > 0x9f) hib += 0x40;

    return (hib << 8) | lob;
}

/*
JISR[hEUCR[hɕϊ

֐

jis2euc  JISR[hEUCR[hɕϊ

`

unsigned int jis2euc(unsigned int jis);



jis  JISR[h

֐l

EUCR[h

ӎ

pijis2euc-test.cj
    jis2euc(0x3441);


    JISR[h7rbgnR[hłAJISKiɂ ꂽ{̕WR[hî͂jłBƂɁAȁE ܂߂C^[lbgE[ɂ͕ʁAJISR[hg ĂB

    AEUCR[hUNIXōLgĂ8rbgnR[h łAJISR[h̑1oCgA2oCg̗0x80Z ̂gpB
*/
unsigned int jis2euc(unsigned int jis)
{
    return jis | 0x8080;
}

/*
EUCR[hJISR[hɕϊ

֐

euc2jis  EUCR[hJISR[hɕϊ

`

unsigned int euc2jis(unsigned int euc);



euc  EUCR[h

֐l

JISR[h

ӎ
    pJiΉEUCR[hSpJiJISR[hɕϊĂB ̂߂ɁA֐ euc2jis-test.cj euc2jis(0xb4c1);


    EUCR[hUNIXōLgĂ8rbgnR[h łAJISR[h̑1oCgA2oCg̗0x80Z ̂gpBɁAANK̔pJiɂẮAO1oCg (0x8e) A2oCgŔpJi\B

    AJISR[h7rbgnR[hłAJISKiɂ ꂽ{̕WR[hî͂jłBƂɁAȁE ܂߂C^[lbgE[ɂ͕ʁAJISR[hg ĂB
*/
unsigned int euc2jis(unsigned int euc)
{
    unsigned int jis;

    if ((euc & 0xff00) == 0x8e00)
        jis = hankaku2zen(euc & 0xff);
    else jis = euc & ~0x8080;
    return jis;
}

/*
_R[hJISR[hɕϊ

֐

kuten2jis  JISR[h_R[hɕϊ

`

unsigned int kuten2jis(unsigned int kuten);



kuten  _R[h

֐l

JISR[h

ӎ

pikuten2jis-test.cj
    kuten2jis(0x3441);


    _R[h͐̂̃~jRɗp銿R[hŁAR[h 犿͂ƂɎgꍇB

    AJISR[h7rbgnR[hłAJISKiɂ ꂽ{̕WR[hî͂jłBƂɁAȁE ܂߂C^[lbgE[ɂ͕ʁAJISR[hg ĂB
*/
unsigned int kuten2jis(unsigned int kuten)
{
    unsigned int hib, lob;
    
    hib = kuten / 100 + 32;
    lob = kuten % 100 + 32;

    return (hib << 8) | lob;
}

/*
JISR[h_R[hɕϊ

֐

jis2kuten  JISR[h_R[hɕϊ

`

unsigned int jis2kuten(unsigned int jis);



jis  JISR[h

֐l

_R[h

ӎ

pijis2kuten-test.cj
    jis2kuten(0x3441);


    JISR[h7rbgnR[hłAJISKiɂ ꂽ{̕WR[hî͂jłBƂɁAȁE ܂߂C^[lbgE[ɂ͕ʁAJISR[hg ĂB

    A_R[h͐̂̃~jRɗp銿R[hŁAR[h 犿͂ƂɎgꍇB
*/
unsigned int jis2kuten(unsigned int jis)
{
    unsigned int hib, lob;
    
    hib = (jis >> 8) & 0xff;
    lob = jis & 0xff;

    return (hib-32) * 100 + (lob-32);
}
