/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol;

import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.ui.IPageLayout;
import com.clustercontrol.util.LoginManager;

/**
 * 初期起動用パースペクティブ<BR>
 * 
 * Hinemosクライアントの初期表示にビューなどを
 * 追加する場合にはこのクラスを変更します。
 * 
 * 
 * @version 1.0.1
 * @since 1.0.0
 */
public class ClusterControlPerspective extends ClusterControlPerspectiveBase {

	// ログ
	private static Log m_log = LogFactory.getLog( ClusterControlPerspective.class );

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
	 */
	@Override
	public void createInitialLayout(IPageLayout layout) {

		super.createInitialLayout(layout);

		//ログインを行います。
		try {
			LoginManager.getContextManager().getNamingContext();
		} catch (NamingException e) {
			m_log.warn("createInitialLayout(), " + e.getMessage(), e);
		}
	}
}