/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.preference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.accesscontrol.util.LocalSession;
import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.util.LoginManager;

public class ClusterControlInitializer extends AbstractPreferenceInitializer {

	// ログ
	private static Log m_log = LogFactory.getLog( LoginManager.class );

	@Override
	public void initializeDefaultPreferences() {
		// TODO Auto-generated method stub
		IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();

		//m_log.debug("ClusterControlInitializer.initializeDefaults()");
		store.setDefault(ClusterControlCorePreferencePage.EJB_URL, LoginManager.VALUE_EJB_URL);
		store.setDefault(ClusterControlCorePreferencePage.KEY_INTERVAL, LocalSession.m_managerPollingInterval);
		store.setDefault(ClusterControlCorePreferencePage.KEY_HTTP_CONNECT_TIMEOUT, EndpointManager.m_httpConnectTimeout);
		store.setDefault(ClusterControlCorePreferencePage.KEY_HTTP_REQUEST_TIMEOUT, EndpointManager.m_httpRequestTimeout);
	}

}
