/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

/**
 * パースペクティブユーティリティクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class PerspectiveUtil {

	// ログ
	private static Log m_log = LogFactory.getLog( PerspectiveUtil.class );

	/**
	 * パースペクティブをクローズ
	 * 
	 * @param perspectivesId
	 */
	public static void closePerspective(String perspectivesId) {

		IWorkbenchPage page =
			PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

		IPerspectiveDescriptor[] openPerspectives = page.getOpenPerspectives();

		for(int i = 0; i < openPerspectives.length; i++){
			String id = openPerspectives[i].getId();
			if(id.equals(perspectivesId)){
				page.closePerspective(openPerspectives[i], true, true);
			}
		}
	}

	/**
	 * Hinemosの全パースペクティブ（デフォルト以外）をクローズするためのメソッド。
	 * ログアウト時にコールされる。
	 * 
	 */
	public static void closeAllHinemosPerspective() {

		IWorkbench workbench = PlatformUI.getWorkbench();

		IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();

		IPerspectiveDescriptor[] openPerspectives = page.getOpenPerspectives();

		// 開いているパースペクティブをすべて閉じる
		for(int i = 0; i < openPerspectives.length; i++){
			String id = openPerspectives[i].getId();
			page.closePerspective(openPerspectives[i], true, true);
		}


		// デフォルトパースぺクティブのみ開く
		try {
			workbench.showPerspective("com.clustercontrol.ClusterControlPerspective", workbench.getActiveWorkbenchWindow());
		} catch (WorkbenchException e) {
			m_log.warn("closeAllHinemosPerspective(), " + e.getMessage(), e);
		}


	}
}