/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.accesscontrol.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.util.Messages;

/**
 * アクセス[ユーザ]ビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * アクセス管理のビュー[ユーザ]のカラムの情報を取得します。
 * Hinemosではロケールによって動作を変えるために定義情報も
 * マネージャから取得します。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetUserListTableDefine {

	/** ユーザID */
	public static final int UID = 0;

	/** 名前 */
	public static final int NAME = 1;

	/** 説明 */
	public static final int DESCRIPTION = 2;

	/** 新規作成ユーザ */
	public static final int CREATOR_NAME = 3;

	/** 作成日時 */
	public static final int CREATE_TIME = 4;

	/** 最終更新ユーザ */
	public static final int MODIFIER_NAME = 5;

	/** 最終更新日時 */
	public static final int MODIFY_TIME = 6;

	/** 初期表示時ソートカラム */
	public static final int SORT_COLUMN_INDEX = UID;

	/** 初期表示時ソートオーダー (昇順=1, 降順=-1) */
	public static final int SORT_ORDER = 1;

	/**
	 * マネージャにSessionBean経由でアクセスし、<BR>
	 * アクセス[ユーザ]ビューのテーブル定義を取得します。
	 * 
	 * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
	 * 
	 * @see com.clustercontrol.accesscontrol.ejb.session.AccessController#getUserListTableDefine(java.util.Locale)
	 */
	public static ArrayList<TableColumnInfo> get() {
		Locale locale = Locale.getDefault();
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();

		/** メイン処理 */
		tableDefine.add(UID, new TableColumnInfo( Messages.getString("user.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT) );
		tableDefine.add(NAME, new TableColumnInfo( Messages.getString("name", locale), TableColumnInfo.NONE, 150, SWT.LEFT) );
		tableDefine.add(DESCRIPTION, new TableColumnInfo( Messages.getString("description", locale), TableColumnInfo.NONE, 200, SWT.LEFT) );
		tableDefine.add(CREATOR_NAME, new TableColumnInfo( Messages.getString("creator.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT) );
		tableDefine.add(CREATE_TIME, new TableColumnInfo( Messages.getString("create.time", locale), TableColumnInfo.NONE, 140, SWT.LEFT) );
		tableDefine.add(MODIFIER_NAME, new TableColumnInfo( Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT) );
		tableDefine.add(MODIFY_TIME, new TableColumnInfo( Messages.getString("update.time", locale), TableColumnInfo.NONE, 140, SWT.LEFT) );

		return tableDefine;
	}
}