/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.accesscontrol.etc.action;

import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import com.clustercontrol.util.LoginManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PerspectiveUtil;

/**
 * ログアウトを行うアクションクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class LogoutAction implements IWorkbenchWindowActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( LogoutAction.class );

	/** アクションID */
	public static final String ID = "com.clustercontrol.accesscontrol.etc.action.LogoutAction";

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	@Override
	public void dispose() {

	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
	 */
	@Override
	public void init(IWorkbenchWindow window) {

	}

	/**
	 * ログアウトを行います。
	 * 
	 * ログアウト時には、以下の処理が実行されます。
	 * 
	 * １．開かれているすべてのパースペクティブを閉じる
	 * ２．デフォルトのパースペクティブを開く
	 * ３．認証情報をクリアする
	 * 
	 * デフォルトのパースペクティブを開く際に、認証情報が必要となるので、
	 * ２→３の順で処理を行う。
	 * 
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	@Override
	public void run(IAction action) {
		runLogout();
	}

	public void runLogout(){
		// パースペクティブを閉じた後に、認証情報を削除する。
		try {

			if(LoginManager.getContextManager().isLogin()){

				PerspectiveUtil.closeAllHinemosPerspective();
				LoginManager.getContextManager().logout();

			}
			else{
				// ログアウト済み通知ダイアログを生成
				MessageDialog.openInformation(
						null,
						Messages.getString("info"),
						Messages.getString("message.accesscontrol.18"));
			}

		} catch (NamingException e) {
			m_log.warn("runLogout(), " + e.getMessage(), e);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {

	}

}
