/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.calendar.ui;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;

import com.clustercontrol.ClusterControlPerspectiveBase;
import com.clustercontrol.calendar.view.AddInfoListView;
import com.clustercontrol.calendar.view.CalendarListView;
import com.clustercontrol.calendar.view.WeekdayInfoListView;

/**
 * カレンダパースペクティブクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CalendarPerspective extends ClusterControlPerspectiveBase {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
	 */
	@Override
	public void createInitialLayout(IPageLayout layout) {
		super.createInitialLayout(layout);

		//エディタ領域のIDを取得
		String editorArea = layout.getEditorArea();
		//エディタ領域の上部60%を占めるフォルダを作成
		IFolderLayout top = layout.createFolder("top", IPageLayout.TOP,
				0.6f, editorArea);
		//エディタ領域の下部40%を占めるフォルダの作成
		IFolderLayout bottom = layout.createFolder("bottom",
				IPageLayout.BOTTOM, 0.4f, editorArea);
		//ID=bottomの左50%を占めるフォルダを作成
		IFolderLayout bottomLeft = layout.createFolder("bottomLeft",
				IPageLayout.LEFT, 0.5f, "bottom");

		top.addView(CalendarListView.ID);
		bottomLeft.addView(WeekdayInfoListView.ID);
		bottom.addView(AddInfoListView.ID);
	}
}