/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.composite.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;

import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.util.CollectiveRunEndpointWrapper;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.collectiverun.InvalidRole_Exception;
import com.clustercontrol.ws.collectiverun.ItemInfo;
import com.clustercontrol.ws.collectiverun.TreeItem;

/**
 * 一括制御階層ツリー削除のSelectionListenerクラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class DeleteTreeItemSelectionListener extends BaseTreeItemSelectionListener {

	// ログ
	private static Log m_log = LogFactory.getLog( DeleteTreeItemSelectionListener.class );

	/**
	 * コンストラクタ
	 * 
	 * @param composite
	 */
	public DeleteTreeItemSelectionListener(TreeComposite composite) {
		super(composite);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	@Override
	public void widgetSelected(SelectionEvent e) {

		//作成中アイテムのチェック
		if(!checkCreateItem())
			return;

		//更新中アイテムのチェック
		if(!checkUpdateItem())
			return;

		TreeItem item = this.composite.getSelectItem();

		if (item instanceof TreeItem) {

			TreeItem parent = item.getParent();

			ItemInfo info = getInfo(item);
			ItemInfo parentInfo = getInfo(parent);

			if(info.getType() == ItemConstant.TYPE_COMMAND_COMPOSITE ||
					info.getType() == ItemConstant.TYPE_PARAMETER_COMPOSITE){
				return ;
			}

			// 確認ダイアログを生成
			Object[] args = { getInfo(item).getName() };
			if (MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					Messages.getString("message.collective.run.10", args))) {

				try {
					CollectiveRunEndpointWrapper.deleteMaster(info, parentInfo);

					TreeItemUtil.removeChildren(parent, item);
					this.composite.setCreateItem(null);

					this.composite.getTreeViewer().refresh(parent);
					this.composite.getTreeViewer().setSelection(
							new StructuredSelection(parent), true);

				} catch (Exception ex) {
					if (ex instanceof InvalidRole_Exception) {
						// 権限なし
						MessageDialog.openInformation(null, Messages.getString("message"),
								Messages.getString("message.accesscontrol.16"));

					} else {
						// 上記以外の例外
						m_log.warn("widgetSelected(), " + ex.getMessage(), ex);
						MessageDialog.openError(
								null,
								Messages.getString("failed"),
								Messages.getString("message.hinemos.failure.unexpected") + ", " + ex.getMessage());

					}

					this.composite.getTreeViewer().refresh(parent);
					this.composite.getTreeViewer().setSelection(
							new StructuredSelection(item), true);
				}
			}
		}
	}

	private ItemInfo getInfo(TreeItem item){
		if(item.getCommandInfo() != null){
			return item.getCommandInfo();
		}
		else if(item.getCommandParameterInfo() != null){
			return item.getCommandParameterInfo();
		}
		else if(item.getParameterInfo() != null){
			return item.getParameterInfo();
		}
		else if(item.getParameterSelectInfo() != null){
			return item.getParameterSelectInfo();
		}
		else if(item.getTypeInfo() != null){
			return item.getTypeInfo();
		}
		else{
			return null;
		}
	}
}

