/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.composite.action;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;

import com.clustercontrol.collectiverun.composite.TreeComposite;

/**
 * 一括制御マスタ情報のModifyListenerクラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MasterInfoModifyListener implements ModifyListener {
	protected TreeComposite composite;

	/**
	 * コンストラクタ
	 * 
	 * @param composite
	 */
	public MasterInfoModifyListener(TreeComposite composite) {
		this.composite = composite;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	@Override
	public void modifyText(ModifyEvent e) {
		this.composite.setUpdateItem(this.composite.getSelectItem());
	}
}

