/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.ui;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;

import com.clustercontrol.ClusterControlPerspectiveBase;
import com.clustercontrol.collectiverun.view.DetailView;
import com.clustercontrol.collectiverun.view.HistoryView;
import com.clustercontrol.collectiverun.view.ParameterView;

/**
 * 一括制御機能のパースペクティブを生成するクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 * 
 */
public class CollectiveRunPerspective extends ClusterControlPerspectiveBase {

	/**
	 * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
	 */
	@Override
	public void createInitialLayout(IPageLayout layout) {
		super.createInitialLayout(layout);

		//エディタ領域のIDを取得
		String editorArea = layout.getEditorArea();
		//エディタ領域の上部80%を占めるフォルダを作成
		IFolderLayout top = layout.createFolder("top", IPageLayout.TOP,
				0.60f, editorArea);
		//ID=topのフォルダの左側50%を占めるフォルダの作成
		IFolderLayout topLeft = layout.createFolder("topLeft",
				IPageLayout.LEFT, 0.4f, "top");
		//エディタ領域の下部30%を占めるフォルダを作成
		IFolderLayout bottom = layout.createFolder("bottom",
				IPageLayout.BOTTOM, 0.40f, editorArea);
		topLeft.addView(ParameterView.ID);
		top.addView(HistoryView.ID);
		bottom.addView(DetailView.ID);
	}
}