/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.composite.action;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.jobmanagement.composite.ScheduleListComposite;
import com.clustercontrol.jobmanagement.view.ScheduleListView;

/**
 * ジョブ[スケジュール]ビューのテーブルビューア用のSelectionChangedListenerです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScheduleSelectionChangedListener implements ISelectionChangedListener {
	/** ジョブ[スケジュール]ビュー用のコンポジット */
	protected ScheduleListComposite m_composite;

	/**
	 * コンストラクタ
	 * 
	 * @param composite ジョブ[スケジュール]ビュー用のコンポジット
	 */
	public ScheduleSelectionChangedListener(ScheduleListComposite composite) {
		m_composite = composite;
	}

	/**
	 * 選択変更時に呼び出されます。
	 * <P>
	 * <ol>
	 * <li>選択変更イベントから選択アイテムを取得します。</li>
	 * <li>選択アイテムをジョブ[スケジュール]ビュー用のコンポジットに設定します。</li>
	 * </ol>
	 * 
	 * @param event 選択変更イベント
	 * 
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	@Override
	public void selectionChanged(SelectionChangedEvent event) {
		ArrayList info = null;

		//ジョブ[スケジュール]ビューのインスタンスを取得
		IWorkbenchPage page = PlatformUI.getWorkbench()
		.getActiveWorkbenchWindow().getActivePage();
		IViewPart viewPart = page.findView(ScheduleListView.ID);

		//選択行を取得
		StructuredSelection selection = (StructuredSelection) event.getSelection();

		if (selection.getFirstElement() != null) {
			info = (ArrayList) ((StructuredSelection) event.getSelection())
			.getFirstElement();

			if (viewPart != null) {
				ScheduleListView view = (ScheduleListView) viewPart.getAdapter(ScheduleListView.class);
				//選択アイテムの確認/未確認の種別でボタン（アクション）の使用可/不可を設定する
				view.setEnabledAction(selection.size(), selection);
			}
		} else {
			if (viewPart != null) {
				ScheduleListView view = (ScheduleListView) viewPart.getAdapter(ScheduleListView.class);
				//選択アイテムの確認/未確認の種別でボタン（アクション）の使用可/不可を設定する
				view.setEnabledAction(0, selection);
			}
		}

		m_composite.setSelectItem(info);
	}
}

