package com.clustercontrol.monitor.util;

import java.util.List;

import javax.activation.DataHandler;
import javax.xml.ws.WebServiceException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.util.EndpointManager.EndpointSetting;
import com.clustercontrol.ws.monitor.EventBatchConfirmInfo;
import com.clustercontrol.ws.monitor.EventFilterInfo;
import com.clustercontrol.ws.monitor.EventDataInfo;
import com.clustercontrol.ws.monitor.EventLogNotFound_Exception;
import com.clustercontrol.ws.monitor.FacilityNotFound_Exception;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.InvalidSetting_Exception;
import com.clustercontrol.ws.monitor.InvalidUserPass_Exception;
import com.clustercontrol.ws.monitor.MonitorEndpoint;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.clustercontrol.ws.monitor.ScopeDataInfo;
import com.clustercontrol.ws.monitor.StatusDataInfo;
import com.clustercontrol.ws.monitor.StatusFilterInfo;
import com.clustercontrol.ws.monitor.ViewListInfo;
import com.sun.xml.internal.ws.client.ClientTransportException;

/**
 * Hinemosマネージャとの通信をするクラス。
 * HAのような複数マネージャ対応のため、このクラスを実装する。
 * 
 * Hinemosマネージャと通信できない場合は、WebServiceExceptionがthrowされる。
 * WebServiceExeptionが出力された場合は、もう一台のマネージャと通信する。
 */
public class MonitorEndpointWrapper {

	// ログ
	private static Log m_log = LogFactory.getLog( MonitorEndpointWrapper.class );

	public static EventDataInfo getEventInfo(String monitorId, String monitorDetailId, String pluginId, String facilityId, Long outputDate)
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorEndpoint()) {
			try {
				MonitorEndpoint endpoint = (MonitorEndpoint) endpointSetting.getEndpoint();
				return endpoint.getEventInfo(monitorId, monitorDetailId, pluginId, facilityId, outputDate);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getEventInfo(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static ViewListInfo getEventList(String facilityId, EventFilterInfo filter, int messages)
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorEndpoint()) {
			try {
				MonitorEndpoint endpoint = (MonitorEndpoint) endpointSetting.getEndpoint();
				return endpoint.getEventList(facilityId, filter, messages);
			} catch (WebServiceException e) {
				wse = e;
				if (e instanceof ClientTransportException) {
					m_log.warn("getEventList(), " + e.getMessage());
				} else {
					m_log.warn("getEventList(), " + e.getMessage(), e);
				}
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<ScopeDataInfo> getScopeList(String facilityId, boolean statusFlag, boolean eventFlag, boolean orderFlg)
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception, FacilityNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorEndpoint()) {
			try {
				MonitorEndpoint endpoint = (MonitorEndpoint) endpointSetting.getEndpoint();
				return endpoint.getScopeList(facilityId, statusFlag, eventFlag, orderFlg);
			} catch (WebServiceException e) {
				wse = e;
				if (e instanceof ClientTransportException) {
					m_log.warn("getScopeList(), " + e.getMessage());
				} else {
					m_log.warn("getScopeList(), " + e.getMessage(), e);
				}
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<StatusDataInfo> getStatusList(String facilityId, StatusFilterInfo filter)
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorEndpoint()) {
			try {
				MonitorEndpoint endpoint = (MonitorEndpoint) endpointSetting.getEndpoint();
				return endpoint.getStatusList(facilityId, filter);
			} catch (WebServiceException e) {
				wse = e;
				if (e instanceof ClientTransportException) {
					m_log.warn("getStatusList(), " + e.getMessage());
				} else {
					m_log.warn("getStatusList(), " + e.getMessage(), e);
				}
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void modifyComment(String monitorId, String monitorDetailId, String pluginId, String facilityId, Long outputDate, String comment, Long commentDate, String commentUser)
	throws EventLogNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorEndpoint()) {
			try {
				MonitorEndpoint endpoint = (MonitorEndpoint) endpointSetting.getEndpoint();
				endpoint.modifyComment(monitorId, monitorDetailId, pluginId, facilityId, outputDate, comment, commentDate, commentUser);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("modifyComment(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static DataHandler downloadEventFile(String facilityId, EventFilterInfo filter, String filename)
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorEndpoint()) {
			try {
				MonitorEndpoint endpoint = (MonitorEndpoint) endpointSetting.getEndpoint();
				return endpoint.downloadEventFile(facilityId, filter, filename);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("downloadEventFile(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void deleteEventFile(String filename)
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorEndpoint()) {
			try {
				MonitorEndpoint endpoint = (MonitorEndpoint) endpointSetting.getEndpoint();
				endpoint.deleteEventFile(filename);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("deleteEventFile(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void modifyConfirm(List<EventDataInfo> list, int confirmType)
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorEndpoint()) {
			try {
				MonitorEndpoint endpoint = (MonitorEndpoint) endpointSetting.getEndpoint();
				endpoint.modifyConfirm(list, confirmType);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("modifyConfirmMultiple(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void modifyBatchConfirm(int confirmType, String facilityId, EventBatchConfirmInfo info)
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorEndpoint()) {
			try {
				MonitorEndpoint endpoint = (MonitorEndpoint) endpointSetting.getEndpoint();
				endpoint.modifyBatchConfirm(confirmType, facilityId, info);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("modifyBatchConfirm(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static boolean deleteStatus(List<StatusDataInfo> statusDataInfoList)
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorEndpoint()) {
			try {
				MonitorEndpoint endpoint = (MonitorEndpoint) endpointSetting.getEndpoint();
				return endpoint.deleteStatus(statusDataInfoList);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("deleteStatus(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}
}
