/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.view.action;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;

import javax.activation.DataHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.dialog.EventReportDialog;
import com.clustercontrol.monitor.util.EventFilterPropertyUtil;
import com.clustercontrol.monitor.util.MonitorEndpointWrapper;
import com.clustercontrol.monitor.view.EventView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.ws.monitor.EventFilterInfo;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.clustercontrol.ws.repository.FacilityTreeItem;

/**
 * 監視[イベントのダウンロード]ダイアログによるイベントの帳票出力処理を行うクライアント側アクションクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class EventReportAction implements IViewActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( EventReportAction.class );

	/** アクションID */
	public static final String ID = "com.clustercontrol.monitor.view.action.DownloadAction";

	/** ビュー */
	private IViewPart viewPart;


	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 * 
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

	/**
	 * 監視[イベントのダウンロード処理]ダイアログで指定された条件に一致するイベントを取得し、
	 * 帳票を出力します。
	 * <p>
	 * <ol>
	 * <li>監視[イベントのダウンロード処理]ダイアログを表示します。</li>
	 * <li>ダイアログで指定された出力情報、検索条件を取得します。</li>
	 * <li>スコープツリーで選択されているアイテムより、ファシリティIDを取得します。</li>
	 * <li>ファシリティIDと検索条件に一致するイベント情報一覧を取得します。 </li>
	 * <li>帳票を出力します。</li>
	 * </ol>
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 * @see com.clustercontrol.monitor.dialog.EventReportDialog
	 * @see com.clustercontrol.monitor.util.EventReportGenerator#run(String, Property, ArrayList, int, String)
	 */
	@Override
	public void run(IAction action) {
		EventView view = (EventView) this.viewPart.getAdapter(EventView.class);

		// ダイアログを生成
		EventReportDialog dialog = new EventReportDialog(this.viewPart.getSite().getShell());

		// ダイアログにて出力が選択された場合、帳票出力
		if (dialog.open() == IDialogConstants.OK_ID) {

			FacilityTreeItem item = view.getScopeTreeComposite().getSelectItem();
			String facilityId = null;
			if (item != null) {
				facilityId = item.getData().getFacilityId();
			}
			Property condition = dialog.getInputData();
			String redirect = dialog.getRedirect();

			// イベント一覧取得
			PropertyUtil.deletePropertyDefine(condition);
			DataHandler handler = null;
			FileOutputStream fileOutputStream = null;
			boolean flag = false;
			String filename = "EventDownload-" + new Date().getTime();
			try {
				EventFilterInfo filter = EventFilterPropertyUtil.property2dto(condition);
				handler = MonitorEndpointWrapper.downloadEventFile(facilityId, filter, filename);
				File file = new File(redirect);
				file.createNewFile();

				fileOutputStream = new FileOutputStream(file);
				handler.writeTo(fileOutputStream);
				flag = true;
			} catch (InvalidRole_Exception e) {
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			} catch (MonitorNotFound_Exception e) {
				MessageDialog.openError(null, Messages.getString("message"),
						Messages.getString("message.monitor.66") + ", " + e.getMessage());
			} catch (HinemosUnknown_Exception e) {
				MessageDialog.openError(null, Messages.getString("message"),
						Messages.getString("message.monitor.66") + ", " + e.getMessage());
			} catch (Exception e) {
				m_log.warn("run() downloadEventFile, " + e.getMessage(), e);
				MessageDialog.openError(
						null,
						Messages.getString("failed"),
						Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
			} finally {
				try {
					if (fileOutputStream != null) {
						fileOutputStream.close();
					}
				} catch (IOException e) {
					// TODO Auto-generated catch block
					m_log.warn("run() fileOutputStream.close(), " + e.getMessage(), e);
				}
				try {
					MonitorEndpointWrapper.deleteEventFile(filename);
				} catch (Exception e) {
					flag = false;
					m_log.warn("run() deleteEventFile, " + e.getMessage(), e);
				}
			}

			// 帳票出力
			if(flag) {
				String[] args = { redirect };
				MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						Messages.getString("message.monitor.45", args));
			} else {
				MessageDialog.openError(
						null,
						Messages.getString("failed"),
						Messages.getString("message.monitor.46"));
			}
		}
	}

	/**
	 * 選択を変更した際に呼ばれます。
	 * 
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}
}
