/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.repository.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.repository.bean.FacilityConstant;
import com.clustercontrol.repository.composite.ScopeListComposite;
import com.clustercontrol.repository.dialog.ScopeCreateDialog;
import com.clustercontrol.repository.view.ScopeListView;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;

/**
 * スコープの作成・変更ダイアログによる、スコープ変更を行うクライアント側アクションクラス<BR>
 * 
 * @version 2.2.0
 * @since 1.0.0
 */
public class ScopeModifyAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.repository.view.action.ScopeModifyAction";

	//	 ----- instance フィールド ----- //

	private IViewPart viewPart; // ビュー

	// ----- instance メソッド ----- //

	/**
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	@Override
	public void run(IAction action) {
		// スコープ一覧より、選択されているアイテムを取得
		// スコープツリーより、選択されているスコープを取得
		ScopeListView view = (ScopeListView) this.viewPart
		.getAdapter(ScopeListView.class);

		FacilityTreeComposite tree = view.getScopeTreeComposite();
		ScopeListComposite list = (ScopeListComposite)view.getListComposite();

		FacilityTreeItem item = null;
		if(tree.getTree().isFocusControl()){
			item = tree.getSelectItem();
		}
		else if(list.getTableViewer().getTable().isFocusControl()){
			item = list.getSelectItem();
		}
		else{
			return;
		}

		// 未選択の場合は、処理終了
		if (item == null) {
			return;
		}
		// コンポジット・ノードを選択している場合は、処理終了
		FacilityInfo info = item.getData();
		if (item == null || info.getFacilityType() == FacilityConstant.TYPE_COMPOSITE
				|| info.getFacilityType() == FacilityConstant.TYPE_NODE) {
			return;
		}

		// ダイアログを生成
		String facilityId = info.getFacilityId();
		ScopeCreateDialog dialog = new ScopeCreateDialog(this.viewPart
				.getSite().getShell(), facilityId, true);

		// ダイアログにて変更が選択された場合、入力内容をもって登録を行う。
		if (dialog.open() == IDialogConstants.OK_ID) {
			tree.update();
			view.update();
		}
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}
}