/*

Copyright (C) since 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.bean;

import java.io.Serializable;
import java.util.ArrayList;

import javax.xml.bind.annotation.XmlType;

/**
 * Hinemosの一括制御コマンド種別情報を格納するクラス。<BR>
 * DTOクラスとしてマネージャ、クライアント間の通信で利用する。
 *
 */
@XmlType(namespace = "http://collectiverun.ws.clustercontrol.com")
public class CommandTypeInfo implements Serializable {

	private static final long serialVersionUID = -2913277654264466641L;
	private String id = null;
	private String nameId = null;
	private Integer orderNo = null;
	private ArrayList<CommandInfo> cmdMsts = new ArrayList<CommandInfo>();

	public void setId(String id) {
		this.id = id;
	}
	public String getId() {
		return id;
	}
	public void setNameId(String nameId) {
		this.nameId = nameId;
	}
	public String getNameId() {
		return nameId;
	}
	public void setOrderNo(Integer orderNo) {
		this.orderNo = orderNo;
	}
	public Integer getOrderNo() {
		return orderNo;
	}
	public void setCmdMsts(ArrayList<CommandInfo> cmdMsts) {
		this.cmdMsts = cmdMsts;
	}
	public ArrayList<CommandInfo> getCmdMsts() {
		return cmdMsts;
	}
	public void addCmdMst(CommandInfo mst){
		this.cmdMsts.add(mst);
	}

}
